/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.subscription.annotation;

import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.context.inject.TenantScope;
import com.cumulocity.microservice.properties.ConfigurationFileProvider;
import com.cumulocity.microservice.subscription.model.MicroserviceMetadataRepresentation;
import com.cumulocity.microservice.subscription.model.core.PlatformProperties;
import com.cumulocity.microservice.subscription.repository.DefaultCredentialsSwitchingPlatform;
import com.cumulocity.microservice.subscription.repository.MicroserviceRepository;
import com.cumulocity.microservice.subscription.repository.MicroserviceRepositoryBuilder;
import com.cumulocity.microservice.subscription.repository.MicroserviceSubscriptionsRepository;
import com.cumulocity.microservice.subscription.repository.application.ApplicationApi;
import com.cumulocity.microservice.subscription.service.MicroserviceSubscriptionsService;
import com.cumulocity.model.JSONBase;
import com.cumulocity.model.authentication.CumulocityBasicCredentials;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.rest.representation.application.MicroserviceManifestRepresentation;
import com.cumulocity.sdk.client.RestOperations;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@ComponentScan(basePackageClasses={MicroserviceSubscriptionsService.class, MicroserviceSubscriptionsRepository.class})
@ConditionalOnProperty(value={"microservice.subscription.enabled"}, havingValue="true", matchIfMissing=true)
public class EnableMicroserviceSubscriptionConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnableMicroserviceSubscriptionConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public PlatformProperties.PlatformPropertiesProvider platformPropertiesProvider() {
        return new PlatformProperties.PlatformPropertiesProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public PlatformProperties platformProperties(PlatformProperties.PlatformPropertiesProvider platformPropertiesProvider) {
        return platformPropertiesProvider.platformProperties(null);
    }

    @Bean
    @ConditionalOnMissingBean
    public MicroserviceRepository microserviceRepository(PlatformProperties properties, Environment environment) {
        Credentials bootstrapUser = properties.getMicroserviceBoostrapUser();
        String applicationName = properties.getApplicationName();
        log.info("Microservice repository will be build for application '{}'.", (Object)applicationName);
        return MicroserviceRepositoryBuilder.microserviceRepositoryBuilder().baseUrl(properties.getUrl()).environment(environment).connector(new DefaultCredentialsSwitchingPlatform(properties.getUrl()).switchTo((CumulocityCredentials)CumulocityBasicCredentials.builder().username(bootstrapUser.getUsername()).password(bootstrapUser.getPassword()).tenantId(bootstrapUser.getTenant()).build())).applicationName(applicationName).applicationKey(properties.getApplicationKey()).build();
    }

    @Bean
    @Order
    @ConditionalOnMissingBean
    public MicroserviceMetadataRepresentation metadata(Environment environment) throws IOException {
        ConfigurationFileProvider provider = new ConfigurationFileProvider(environment);
        Iterable manifests = provider.find(new String[]{"cumulocity"}, new String[]{".json"});
        if (!Iterables.isEmpty((Iterable)manifests)) {
            try (BufferedReader reader = Files.newBufferedReader((Path)Iterables.getFirst((Iterable)manifests, null), Charsets.UTF_8);){
                MicroserviceManifestRepresentation manifest = (MicroserviceManifestRepresentation)JSONBase.fromJSON((Reader)reader, MicroserviceManifestRepresentation.class);
                MicroserviceMetadataRepresentation microserviceMetadataRepresentation = MicroserviceMetadataRepresentation.microserviceMetadataRepresentation().requiredRoles((Collection)MoreObjects.firstNonNull((Object)manifest.getRequiredRoles(), (Object)ImmutableList.of())).roles((Collection)MoreObjects.firstNonNull((Object)manifest.getRoles(), (Object)ImmutableList.of())).extensions(manifest.getExtensions()).build();
                return microserviceMetadataRepresentation;
            }
        }
        return new MicroserviceMetadataRepresentation();
    }

    @Bean
    @TenantScope
    @ConditionalOnMissingBean
    public ApplicationApi applicationApi(RestOperations restOperations) {
        return new ApplicationApi(restOperations);
    }
}

