/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.subscription.service.impl;

import com.cumulocity.microservice.subscription.model.MicroserviceSubscriptionsInitializedEvent;
import com.cumulocity.microservice.subscription.model.core.PlatformProperties;
import com.cumulocity.microservice.subscription.service.MicroserviceSubscriptionsService;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;

@Service
public class MicroserviceSubscriptionScheduler
implements ApplicationListener<ContextRefreshedEvent> {
    @Generated
    private final Object $lock = new Object[0];
    private static final Logger log = LoggerFactory.getLogger(MicroserviceSubscriptionScheduler.class);
    private final ScheduledExecutorService subscriptionsWatcher = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("subscriptions-%d").setDaemon(true).build());
    private final MicroserviceSubscriptionsService service;
    private final PlatformProperties properties;
    private final ApplicationEventPublisher eventPublisher;
    private final AtomicBoolean started = new AtomicBoolean(false);

    @Autowired
    public MicroserviceSubscriptionScheduler(MicroserviceSubscriptionsService service, PlatformProperties properties, ApplicationEventPublisher eventPublisher) {
        this.service = service;
        this.properties = properties;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextRefreshedEvent applicationContextEvent) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.started.get()) {
                return;
            }
            if (PlatformProperties.IsolationLevel.PER_TENANT.equals((Object)this.properties.getIsolation())) {
                this.subscribe();
            } else {
                this.schedulePeriodicSubscription();
            }
        }
    }

    private void subscribe() {
        this.service.subscribe();
        this.eventPublisher.publishEvent((Object)new MicroserviceSubscriptionsInitializedEvent());
        this.started.set(true);
    }

    private void schedulePeriodicSubscription() {
        int subscriptionDelay = this.getSubscriptionDelay();
        int subscriptionInitialDelay = this.getSubscriptionInitialDelay();
        log.info("Start; subscriptionDelay = {}, subscriptionInitialDelay = {}", (Object)subscriptionDelay, (Object)subscriptionInitialDelay);
        if (subscriptionDelay <= 0) {
            log.warn("Subscription delay should be greater than 0, is: {}", (Object)subscriptionDelay);
            return;
        }
        this.subscriptionsWatcher.scheduleWithFixedDelay(() -> {
            try {
                this.service.subscribe();
            }
            catch (Throwable e) {
                log.error("Error while reacting on microservice subscription", e);
            }
            finally {
                if (!this.started.get()) {
                    this.eventPublisher.publishEvent((Object)new MicroserviceSubscriptionsInitializedEvent());
                }
                this.started.set(true);
            }
        }, subscriptionInitialDelay, subscriptionDelay, TimeUnit.MILLISECONDS);
    }

    private int getSubscriptionDelay() {
        return (Integer)MoreObjects.firstNonNull((Object)this.properties.getSubscriptionDelay(), (Object)10000);
    }

    private int getSubscriptionInitialDelay() {
        return (Integer)MoreObjects.firstNonNull((Object)this.properties.getSubscriptionInitialDelay(), (Object)30000);
    }
}

