/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.subscription.repository;

import com.cumulocity.microservice.context.credentials.MicroserviceCredentials;
import com.cumulocity.microservice.subscription.model.MicroserviceMetadataRepresentation;
import com.cumulocity.microservice.subscription.model.core.PlatformProperties;
import com.cumulocity.microservice.subscription.repository.MicroserviceRepository;
import com.cumulocity.rest.representation.application.ApplicationRepresentation;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class MicroserviceSubscriptionsRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicroserviceSubscriptionsRepository.class);
    private final MicroserviceRepository repository;
    private final PlatformProperties platformProperties;
    private volatile Collection<MicroserviceCredentials> currentSubscriptions = Lists.newArrayList();

    @ConstructorProperties(value={"repository", "platformProperties"})
    @Autowired
    public MicroserviceSubscriptionsRepository(MicroserviceRepository repository, PlatformProperties platformProperties) {
        this.repository = repository;
        this.platformProperties = platformProperties;
    }

    public Collection<MicroserviceCredentials> getCurrentSubscriptions() {
        return this.currentSubscriptions;
    }

    public Optional<ApplicationRepresentation> register(MicroserviceMetadataRepresentation metadata) {
        Optional<ApplicationRepresentation> application = Optional.ofNullable(this.repository.register(metadata));
        this.checkRegisteredApplicationKey(application);
        return application;
    }

    @Deprecated
    public Optional<ApplicationRepresentation> register(String applicationName, MicroserviceMetadataRepresentation metadata) {
        Optional<ApplicationRepresentation> application = Optional.ofNullable(this.repository.register(applicationName, metadata));
        this.checkRegisteredApplicationKey(application);
        return application;
    }

    private void checkRegisteredApplicationKey(Optional<ApplicationRepresentation> application) {
        if (application.isPresent() && !application.get().getKey().equals(this.platformProperties.getApplicationKey())) {
            log.warn("Configured application key '{}' differs from the registered application key: '{}'. Updating configuration.", (Object)this.platformProperties.getApplicationKey(), (Object)application.get().getKey());
            this.platformProperties.setApplicationKey(application.get().getKey());
        }
    }

    public Subscriptions retrieveSubscriptions(String applicationId) {
        List subscriptions = StreamSupport.stream(this.repository.getSubscriptions(applicationId).spliterator(), false).map(representation -> MicroserviceCredentials.builder().username(representation.getName()).tenant(representation.getTenant()).password(representation.getPassword()).oAuthAccessToken(null).xsrfToken(null).appKey(this.platformProperties.getApplicationKey()).build()).collect(Collectors.toCollection(ArrayList::new));
        this.moveManagementToFront(subscriptions);
        return this.diffWithCurrentSubscriptions(subscriptions);
    }

    private void moveManagementToFront(List<MicroserviceCredentials> subscriptions) {
        if (CollectionUtils.size(subscriptions) < 2) {
            return;
        }
        MicroserviceCredentials management = null;
        for (MicroserviceCredentials subscription : subscriptions) {
            if (!"management".equals(subscription.getTenant())) continue;
            management = subscription;
            break;
        }
        if (management != null) {
            subscriptions.remove(management);
            subscriptions.add(0, management);
        }
    }

    public Subscriptions diffWithCurrentSubscriptions(List<MicroserviceCredentials> credentials) {
        Collection<MicroserviceCredentials> removed = this.subtract(this.currentSubscriptions, credentials);
        Collection<MicroserviceCredentials> added = this.subtract(credentials, this.currentSubscriptions);
        return Subscriptions.builder().all(credentials).removed(removed).added(added).build();
    }

    private Collection<MicroserviceCredentials> subtract(Collection<MicroserviceCredentials> a, Collection<MicroserviceCredentials> b) {
        return a.stream().filter(credentials -> !b.contains(credentials)).collect(Collectors.toList());
    }

    public void updateCurrentSubscriptions(Collection<MicroserviceCredentials> subscriptions) {
        this.currentSubscriptions = subscriptions;
    }

    public static class Subscriptions {
        private final Collection<MicroserviceCredentials> all;
        private final Collection<MicroserviceCredentials> removed;
        private final Collection<MicroserviceCredentials> added;

        @ConstructorProperties(value={"all", "removed", "added"})
        Subscriptions(Collection<MicroserviceCredentials> all, Collection<MicroserviceCredentials> removed, Collection<MicroserviceCredentials> added) {
            this.all = all;
            this.removed = removed;
            this.added = added;
        }

        public static SubscriptionsBuilder builder() {
            return new SubscriptionsBuilder();
        }

        public Collection<MicroserviceCredentials> getAll() {
            return this.all;
        }

        public Collection<MicroserviceCredentials> getRemoved() {
            return this.removed;
        }

        public Collection<MicroserviceCredentials> getAdded() {
            return this.added;
        }

        @Generated
        public String toString() {
            return "MicroserviceSubscriptionsRepository.Subscriptions(all=" + this.getAll() + ", removed=" + this.getRemoved() + ", added=" + this.getAdded() + ")";
        }

        public static class SubscriptionsBuilder {
            private Collection<MicroserviceCredentials> all;
            private Collection<MicroserviceCredentials> removed;
            private Collection<MicroserviceCredentials> added;

            SubscriptionsBuilder() {
            }

            public SubscriptionsBuilder all(Collection<MicroserviceCredentials> all) {
                this.all = all;
                return this;
            }

            public SubscriptionsBuilder removed(Collection<MicroserviceCredentials> removed) {
                this.removed = removed;
                return this;
            }

            public SubscriptionsBuilder added(Collection<MicroserviceCredentials> added) {
                this.added = added;
                return this;
            }

            public Subscriptions build() {
                return new Subscriptions(this.all, this.removed, this.added);
            }
        }
    }
}

