/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.subscription.repository.application;

import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.google.common.base.Supplier;
import lombok.Generated;
import org.springframework.util.StringUtils;

public class ApplicationApiRepresentation
extends AbstractExtensibleRepresentation {
    public static final String APPLICATION_ID = "{{applicationId}}";
    public static final String APPLICATION_NAME = "{{applicationName}}";
    private final Supplier<String> baseUrl;
    private final String updateUrl;
    private final String currentApplicationSubscriptions;
    private final String currentApplication;
    private final String collectionUrl;
    private final String getById;
    private final String findByNameUrl;
    private final String bootstrapUserUrl;
    private final String applicationSubscriptions;

    public static ApplicationApiRepresentation of(Supplier<String> baseUrl) {
        return ApplicationApiRepresentation.applicationApiRepresentation().baseUrl(baseUrl).collectionUrl("/application/applications").currentApplicationSubscriptions("/application/currentApplication/subscriptions").currentApplication("/application/currentApplication").findByNameUrl("/application/applicationsByName/{{applicationName}}").getById("/application/applications/{{applicationId}}").bootstrapUserUrl("/application/applications/{{applicationId}}/bootstrapUser").applicationSubscriptions("/application/applications/{{applicationId}}/subscriptions").build();
    }

    public String getCollectionUrl() {
        return this.url(this.collectionUrl, null, null);
    }

    public String getFindByNameUrl(String applicationName) {
        return this.url(this.findByNameUrl, applicationName, null);
    }

    public String getCurrentApplication() {
        return this.url(this.currentApplication, null, null);
    }

    public String getCurrentApplicationSubscriptions() {
        return this.url(this.currentApplicationSubscriptions, null, null);
    }

    public String getApplicationSubscriptions(String applicationId) {
        return this.url(this.applicationSubscriptions, null, applicationId);
    }

    public String getByIdUrl(String id) {
        return this.url(this.getById, null, id);
    }

    public String getBootstrapUserUrl(String id) {
        return this.url(this.bootstrapUserUrl, null, id);
    }

    private String url(String url, String applicationName, String applicationId) {
        String prefix = StringUtils.trimTrailingCharacter((String)((String)this.baseUrl.get()), (char)'/');
        String suffix = StringUtils.trimLeadingCharacter((String)url.replace(APPLICATION_NAME, String.valueOf(applicationName)).replace(APPLICATION_ID, String.valueOf(applicationId)), (char)'/');
        return prefix + "/" + suffix;
    }

    @Generated
    public static ApplicationApiRepresentationBuilder applicationApiRepresentation() {
        return new ApplicationApiRepresentationBuilder();
    }

    @Generated
    public ApplicationApiRepresentation(Supplier<String> baseUrl, String updateUrl, String currentApplicationSubscriptions, String currentApplication, String collectionUrl, String getById, String findByNameUrl, String bootstrapUserUrl, String applicationSubscriptions) {
        this.baseUrl = baseUrl;
        this.updateUrl = updateUrl;
        this.currentApplicationSubscriptions = currentApplicationSubscriptions;
        this.currentApplication = currentApplication;
        this.collectionUrl = collectionUrl;
        this.getById = getById;
        this.findByNameUrl = findByNameUrl;
        this.bootstrapUserUrl = bootstrapUserUrl;
        this.applicationSubscriptions = applicationSubscriptions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationApiRepresentation)) {
            return false;
        }
        ApplicationApiRepresentation other = (ApplicationApiRepresentation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Supplier<String> this$baseUrl = this.baseUrl;
        Supplier<String> other$baseUrl = other.baseUrl;
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$updateUrl = this.updateUrl;
        String other$updateUrl = other.updateUrl;
        if (this$updateUrl == null ? other$updateUrl != null : !this$updateUrl.equals(other$updateUrl)) {
            return false;
        }
        String this$currentApplicationSubscriptions = this.getCurrentApplicationSubscriptions();
        String other$currentApplicationSubscriptions = other.getCurrentApplicationSubscriptions();
        if (this$currentApplicationSubscriptions == null ? other$currentApplicationSubscriptions != null : !this$currentApplicationSubscriptions.equals(other$currentApplicationSubscriptions)) {
            return false;
        }
        String this$currentApplication = this.getCurrentApplication();
        String other$currentApplication = other.getCurrentApplication();
        if (this$currentApplication == null ? other$currentApplication != null : !this$currentApplication.equals(other$currentApplication)) {
            return false;
        }
        String this$collectionUrl = this.getCollectionUrl();
        String other$collectionUrl = other.getCollectionUrl();
        if (this$collectionUrl == null ? other$collectionUrl != null : !this$collectionUrl.equals(other$collectionUrl)) {
            return false;
        }
        String this$getById = this.getById;
        String other$getById = other.getById;
        if (this$getById == null ? other$getById != null : !this$getById.equals(other$getById)) {
            return false;
        }
        String this$findByNameUrl = this.findByNameUrl;
        String other$findByNameUrl = other.findByNameUrl;
        if (this$findByNameUrl == null ? other$findByNameUrl != null : !this$findByNameUrl.equals(other$findByNameUrl)) {
            return false;
        }
        String this$bootstrapUserUrl = this.bootstrapUserUrl;
        String other$bootstrapUserUrl = other.bootstrapUserUrl;
        if (this$bootstrapUserUrl == null ? other$bootstrapUserUrl != null : !this$bootstrapUserUrl.equals(other$bootstrapUserUrl)) {
            return false;
        }
        String this$applicationSubscriptions = this.applicationSubscriptions;
        String other$applicationSubscriptions = other.applicationSubscriptions;
        return !(this$applicationSubscriptions == null ? other$applicationSubscriptions != null : !this$applicationSubscriptions.equals(other$applicationSubscriptions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApplicationApiRepresentation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Supplier<String> $baseUrl = this.baseUrl;
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $updateUrl = this.updateUrl;
        result = result * 59 + ($updateUrl == null ? 43 : $updateUrl.hashCode());
        String $currentApplicationSubscriptions = this.getCurrentApplicationSubscriptions();
        result = result * 59 + ($currentApplicationSubscriptions == null ? 43 : $currentApplicationSubscriptions.hashCode());
        String $currentApplication = this.getCurrentApplication();
        result = result * 59 + ($currentApplication == null ? 43 : $currentApplication.hashCode());
        String $collectionUrl = this.getCollectionUrl();
        result = result * 59 + ($collectionUrl == null ? 43 : $collectionUrl.hashCode());
        String $getById = this.getById;
        result = result * 59 + ($getById == null ? 43 : $getById.hashCode());
        String $findByNameUrl = this.findByNameUrl;
        result = result * 59 + ($findByNameUrl == null ? 43 : $findByNameUrl.hashCode());
        String $bootstrapUserUrl = this.bootstrapUserUrl;
        result = result * 59 + ($bootstrapUserUrl == null ? 43 : $bootstrapUserUrl.hashCode());
        String $applicationSubscriptions = this.applicationSubscriptions;
        result = result * 59 + ($applicationSubscriptions == null ? 43 : $applicationSubscriptions.hashCode());
        return result;
    }

    @Generated
    public static class ApplicationApiRepresentationBuilder {
        @Generated
        private Supplier<String> baseUrl;
        @Generated
        private String updateUrl;
        @Generated
        private String currentApplicationSubscriptions;
        @Generated
        private String currentApplication;
        @Generated
        private String collectionUrl;
        @Generated
        private String getById;
        @Generated
        private String findByNameUrl;
        @Generated
        private String bootstrapUserUrl;
        @Generated
        private String applicationSubscriptions;

        @Generated
        ApplicationApiRepresentationBuilder() {
        }

        @Generated
        public ApplicationApiRepresentationBuilder baseUrl(Supplier<String> baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public ApplicationApiRepresentationBuilder updateUrl(String updateUrl) {
            this.updateUrl = updateUrl;
            return this;
        }

        @Generated
        public ApplicationApiRepresentationBuilder currentApplicationSubscriptions(String currentApplicationSubscriptions) {
            this.currentApplicationSubscriptions = currentApplicationSubscriptions;
            return this;
        }

        @Generated
        public ApplicationApiRepresentationBuilder currentApplication(String currentApplication) {
            this.currentApplication = currentApplication;
            return this;
        }

        @Generated
        public ApplicationApiRepresentationBuilder collectionUrl(String collectionUrl) {
            this.collectionUrl = collectionUrl;
            return this;
        }

        @Generated
        public ApplicationApiRepresentationBuilder getById(String getById) {
            this.getById = getById;
            return this;
        }

        @Generated
        public ApplicationApiRepresentationBuilder findByNameUrl(String findByNameUrl) {
            this.findByNameUrl = findByNameUrl;
            return this;
        }

        @Generated
        public ApplicationApiRepresentationBuilder bootstrapUserUrl(String bootstrapUserUrl) {
            this.bootstrapUserUrl = bootstrapUserUrl;
            return this;
        }

        @Generated
        public ApplicationApiRepresentationBuilder applicationSubscriptions(String applicationSubscriptions) {
            this.applicationSubscriptions = applicationSubscriptions;
            return this;
        }

        @Generated
        public ApplicationApiRepresentation build() {
            return new ApplicationApiRepresentation(this.baseUrl, this.updateUrl, this.currentApplicationSubscriptions, this.currentApplication, this.collectionUrl, this.getById, this.findByNameUrl, this.bootstrapUserUrl, this.applicationSubscriptions);
        }

        @Generated
        public String toString() {
            return "ApplicationApiRepresentation.ApplicationApiRepresentationBuilder(baseUrl=" + this.baseUrl + ", updateUrl=" + this.updateUrl + ", currentApplicationSubscriptions=" + this.currentApplicationSubscriptions + ", currentApplication=" + this.currentApplication + ", collectionUrl=" + this.collectionUrl + ", getById=" + this.getById + ", findByNameUrl=" + this.findByNameUrl + ", bootstrapUserUrl=" + this.bootstrapUserUrl + ", applicationSubscriptions=" + this.applicationSubscriptions + ")";
        }
    }
}

