/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.subscription.service.impl;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.MicroserviceCredentials;
import com.cumulocity.microservice.subscription.model.MicroserviceMetadataRepresentation;
import com.cumulocity.microservice.subscription.model.MicroserviceSubscriptionAddedEvent;
import com.cumulocity.microservice.subscription.model.MicroserviceSubscriptionRemovedEvent;
import com.cumulocity.microservice.subscription.model.core.PlatformProperties;
import com.cumulocity.microservice.subscription.repository.MicroserviceSubscriptionsRepository;
import com.cumulocity.microservice.subscription.service.MicroserviceSubscriptionsService;
import com.cumulocity.rest.representation.application.ApplicationRepresentation;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class MicroserviceSubscriptionsServiceImpl
implements MicroserviceSubscriptionsService {
    @Generated
    private final Object $lock = new Object[0];
    private static final Logger log = LoggerFactory.getLogger(MicroserviceSubscriptionsService.class);
    private final PlatformProperties properties;
    private final ApplicationEventPublisher eventPublisher;
    private final MicroserviceSubscriptionsRepository repository;
    private final MicroserviceMetadataRepresentation microserviceMetadataRepresentation;
    private final ContextService<MicroserviceCredentials> contextService;
    private volatile boolean subscribing = false;
    private final List<MicroserviceCredentials> subscribingCredentials = new CopyOnWriteArrayList<MicroserviceCredentials>();
    private volatile boolean registeredSuccessfully = false;
    private final List<MicroserviceChangedListener> listeners = Lists.newArrayList((Object[])new MicroserviceChangedListener[]{new MicroserviceChangedListener(){

        public boolean apply(Object event) {
            try {
                if (event instanceof ApplicationEvent) {
                    MicroserviceSubscriptionsServiceImpl.this.eventPublisher.publishEvent((ApplicationEvent)event);
                } else {
                    MicroserviceSubscriptionsServiceImpl.this.eventPublisher.publishEvent(event);
                }
                return true;
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                return false;
            }
        }
    }});

    @Autowired
    public MicroserviceSubscriptionsServiceImpl(PlatformProperties properties, ApplicationEventPublisher eventPublisher, MicroserviceSubscriptionsRepository repository, MicroserviceMetadataRepresentation microserviceMetadataRepresentation, ContextService<MicroserviceCredentials> contextService) {
        this.properties = properties;
        this.eventPublisher = eventPublisher;
        this.repository = repository;
        this.microserviceMetadataRepresentation = microserviceMetadataRepresentation;
        this.contextService = contextService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen(MicroserviceChangedListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.listeners.add(listener);
            for (MicroserviceCredentials user : this.repository.getCurrentSubscriptions()) {
                this.invokeAdded(user, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void listen(Class<T> clazz, MicroserviceChangedListener<T> listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.listen(event -> {
                if (clazz.isInstance(event)) {
                    return listener.apply(event);
                }
                return true;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe() {
        Object object = this.$lock;
        synchronized (object) {
            try {
                this.subscribing = true;
                this.subscribingCredentials.clear();
                ApplicationRepresentation application = this.registerApplication();
                MicroserviceSubscriptionsRepository.Subscriptions subscriptions = this.retrieveSubscriptions(application);
                subscriptions.getRemoved().stream().filter(user -> {
                    this.log("Remove subscription: {}", (MicroserviceCredentials)user);
                    for (MicroserviceChangedListener listener : this.listeners) {
                        if (this.invokeRemoved((MicroserviceCredentials)user, listener)) continue;
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
                List successfullyAdded = subscriptions.getAdded().stream().filter(user -> {
                    this.log("Add subscription: {}", (MicroserviceCredentials)user);
                    MicroserviceCredentials enhancedUser = MicroserviceCredentials.copyOf((MicroserviceCredentials)user).appKey(application.getKey()).build();
                    this.subscribingCredentials.add(enhancedUser);
                    for (MicroserviceChangedListener listener : this.listeners) {
                        if (this.invokeAdded(enhancedUser, listener)) continue;
                        this.subscribingCredentials.remove(enhancedUser);
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
                this.repository.updateCurrentSubscriptions(subscriptions.getAll().stream().filter(user -> {
                    if (subscriptions.getAdded().contains(user)) {
                        return successfullyAdded.contains(user);
                    }
                    return true;
                }).collect(Collectors.toList()));
            }
            finally {
                this.subscribingCredentials.clear();
                this.subscribing = false;
            }
        }
    }

    private MicroserviceSubscriptionsRepository.Subscriptions retrieveSubscriptions(ApplicationRepresentation application) {
        if (PlatformProperties.IsolationLevel.PER_TENANT.equals((Object)this.properties.getIsolation())) {
            MicroserviceCredentials microserviceCredentials = MicroserviceCredentials.builder().username(this.properties.getMicroserviceUser().getUsername()).tenant(this.properties.getMicroserviceUser().getTenant()).password(this.properties.getMicroserviceUser().getPassword()).appKey(this.properties.getMicroserviceUser().getAppKey()).build();
            return this.repository.diffWithCurrentSubscriptions(Collections.singletonList(microserviceCredentials));
        }
        return this.repository.retrieveSubscriptions(application.getId());
    }

    private ApplicationRepresentation registerApplication() {
        ApplicationRepresentation application = this.repository.register(this.properties.getApplicationName(), this.microserviceMetadataRepresentation).orElseThrow(() -> new IllegalStateException(String.format("Application %s not found", this.properties.getApplicationName())));
        this.registeredSuccessfully = true;
        return application;
    }

    private boolean invokeRemoved(MicroserviceCredentials user, MicroserviceChangedListener listener) {
        try {
            return (Boolean)this.contextService.callWithinContext((Object)user, () -> listener.apply(new MicroserviceSubscriptionRemovedEvent(user.getTenant())));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private boolean invokeAdded(MicroserviceCredentials user, MicroserviceChangedListener listener) {
        try {
            return (Boolean)this.contextService.callWithinContext((Object)user, () -> listener.apply(new MicroserviceSubscriptionAddedEvent(user)));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    @Override
    public Collection<MicroserviceCredentials> getAll() {
        return this.repository.getCurrentSubscriptions();
    }

    @Override
    public Optional<MicroserviceCredentials> getCredentials(String tenant) {
        for (MicroserviceCredentials subscription : this.repository.getCurrentSubscriptions()) {
            if (!subscription.getTenant().equals(tenant)) continue;
            return Optional.of(subscription);
        }
        for (MicroserviceCredentials credentials : this.subscribingCredentials) {
            if (!credentials.getTenant().equals(tenant)) continue;
            return Optional.of(credentials);
        }
        if (!this.subscribing) {
            this.subscribe();
            for (MicroserviceCredentials subscription : this.repository.getCurrentSubscriptions()) {
                if (!subscription.getTenant().equals(tenant)) continue;
                return Optional.of(subscription);
            }
        }
        return Optional.empty();
    }

    @Override
    public String getTenant() {
        return ((MicroserviceCredentials)this.contextService.getContext()).getTenant();
    }

    @Override
    public void runForEachTenant(Runnable runnable) {
        for (MicroserviceCredentials credentials : this.getAll()) {
            this.contextService.runWithinContext((Object)credentials, runnable);
        }
    }

    @Override
    public void runForTenant(String tenant, Runnable runnable) {
        this.callForTenant(tenant, () -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public <T> T callForTenant(String tenant, Callable<T> runnable) {
        Optional<MicroserviceCredentials> maybeCredentials = this.getCredentials(tenant);
        return maybeCredentials.map(microserviceCredentials -> this.contextService.callWithinContext(microserviceCredentials, runnable)).orElse(null);
    }

    @Override
    public boolean isRegisteredSuccessfully() {
        return this.registeredSuccessfully;
    }

    private void log(String s, MicroserviceCredentials user) {
        Object newPassword = user.getPassword();
        if (newPassword != null && ((String)newPassword).length() > 3) {
            newPassword = ((String)newPassword).substring(0, 2) + "*******";
        }
        log.debug(s, (Object)user.withPassword((String)newPassword));
    }

    public static interface MicroserviceChangedListener<T> {
        public boolean apply(T var1) throws Exception;
    }
}

