/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.settings.service.impl;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.MicroserviceCredentials;
import com.cumulocity.microservice.settings.repository.CurrentApplicationSettingsApi;
import com.cumulocity.microservice.settings.service.MicroserviceSettingsService;
import com.cumulocity.microservice.subscription.model.core.PlatformProperties;
import com.cumulocity.rest.representation.tenant.OptionsRepresentation;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceSettingsServiceImpl
implements MicroserviceSettingsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicroserviceSettingsServiceImpl.class);
    private final PlatformProperties platformProperties;
    private final ContextService<MicroserviceCredentials> contextService;
    private final CurrentApplicationSettingsApi settingsApi;
    private final Cache<String, Map<String, String>> cachedSettings = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    @Override
    public Map<String, String> getAll() {
        final MicroserviceCredentials credentials = this.getCurrentCredentials();
        try {
            return (Map)this.cachedSettings.get((Object)credentials.getTenant(), (Callable)new Callable<Map<String, String>>(){

                @Override
                public Map<String, String> call() {
                    log.debug("Loading tenant option settings for tenant: {}", (Object)credentials.getTenant());
                    if (MicroserviceSettingsServiceImpl.this.isBootstrapUser(credentials.getUsername())) {
                        log.warn("Loading tenant options using bootstrap credentials!");
                    }
                    return MicroserviceSettingsServiceImpl.this.toMap((OptionsRepresentation)MicroserviceSettingsServiceImpl.this.contextService.callWithinContext((Object)credentials, (Callable)new Callable<OptionsRepresentation>(){

                        @Override
                        public OptionsRepresentation call() {
                            return MicroserviceSettingsServiceImpl.this.settingsApi.findAll();
                        }
                    }));
                }
            });
        }
        catch (ExecutionException e) {
            log.error("Loading tenant option settings failed: {}", (Object)e.getMessage());
            log.debug("Loading tenant option settings failed: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyMap();
        }
    }

    @Override
    public <T> T getAs(Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.convertValue(this.getAll(), clazz);
    }

    private Map<String, String> toMap(OptionsRepresentation settings) {
        HashMap settingsMap = Maps.newHashMap();
        for (String key : settings.propertyNames()) {
            settingsMap.put(key, settings.getProperty(key));
        }
        return settingsMap;
    }

    @Override
    public String getCredential(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (!((String)key).startsWith("credentials")) {
            key = "credentials." + (String)key;
        }
        return this.get((String)key);
    }

    @Override
    public String get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getAll().get(key);
    }

    @Override
    public void evict() {
        if (!this.contextService.isInContext()) {
            throw new IllegalStateException("Cannot evict tenant settings when not in scope");
        }
        MicroserviceCredentials credentials = this.getCurrentCredentials();
        this.cachedSettings.invalidate((Object)credentials.getTenant());
    }

    private MicroserviceCredentials getCurrentCredentials() {
        if (this.contextService.isInContext()) {
            return (MicroserviceCredentials)this.contextService.getContext();
        }
        return (MicroserviceCredentials)this.platformProperties.getMicroserviceBoostrapUser();
    }

    private boolean isBootstrapUser(String username) {
        return username.startsWith("servicebootstrap_");
    }

    @Generated
    public MicroserviceSettingsServiceImpl(PlatformProperties platformProperties, ContextService<MicroserviceCredentials> contextService, CurrentApplicationSettingsApi settingsApi) {
        this.platformProperties = platformProperties;
        this.contextService = contextService;
        this.settingsApi = settingsApi;
    }
}

