/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.settings.repository;

import com.cumulocity.rest.representation.tenant.OptionsRepresentation;
import com.cumulocity.sdk.client.RestOperations;
import jakarta.ws.rs.core.MediaType;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CurrentApplicationSettingsApi {
    private static final Logger log = LoggerFactory.getLogger(CurrentApplicationSettingsApi.class);
    private static final String CURRENT_APPLICATION_SETTINGS = "application/currentApplication/settings";
    private final RestOperations rest;
    private final Supplier<String> baseUrl;

    public OptionsRepresentation findAll() {
        return SettingsRetry.with(this.getMaxIteration(), this.getBackoffRate()).executeWithRetry(() -> (OptionsRepresentation)this.rest.get(this.url(), MediaType.APPLICATION_JSON_TYPE, OptionsRepresentation.class));
    }

    private String url() {
        String prefix = StringUtils.trimTrailingCharacter((String)this.baseUrl.get(), (char)'/');
        return prefix + "/application/currentApplication/settings";
    }

    protected int getMaxIteration() {
        return 3;
    }

    protected int getBackoffRate() {
        return 5;
    }

    @Generated
    public CurrentApplicationSettingsApi(RestOperations rest, Supplier<String> baseUrl) {
        this.rest = rest;
        this.baseUrl = baseUrl;
    }

    private static class SettingsRetry<T> {
        private final int maxIterations;
        private final int backoffRate;
        private int currentExecutionNumber;

        private SettingsRetry(int maxIterations, int backoffRate) {
            this.maxIterations = maxIterations;
            this.backoffRate = backoffRate;
            this.currentExecutionNumber = 0;
        }

        public static <T> SettingsRetry<T> with(int maxIterations, int backOfRate) {
            return new SettingsRetry<T>(maxIterations, backOfRate);
        }

        public T executeWithRetry(Supplier<T> supplier) {
            try {
                return this.execute(supplier);
            }
            catch (Exception e) {
                if (this.currentExecutionNumber < this.maxIterations) {
                    return this.executeWithWait(supplier, e);
                }
                throw e;
            }
        }

        private T executeWithWait(Supplier<T> supplier, Exception e) {
            log.debug("Error while calling getting microservice platform settings retry will be attempted", (Throwable)e);
            try {
                Thread.sleep((long)(this.backoffRate * this.currentExecutionNumber) * 1000L);
            }
            catch (InterruptedException interruptedException) {
                log.error("Error while waiting to retry", (Throwable)e);
            }
            return this.executeWithRetry(supplier);
        }

        private T execute(Supplier<T> supplier) {
            ++this.currentExecutionNumber;
            return supplier.get();
        }
    }
}

