/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.filter.util;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.util.StringUtils;

public class HttpRequestUtils {
    public static final String X_CUMULOCITY_APPLICATION_KEY = "X-Cumulocity-Application-Key";
    public static final String TFA_TOKEN_HEADER = "TFAToken";
    public static final String LOGIN_SEPARATOR = "/";
    public static final String AUTH_PREFIX = "BASIC ";
    public static final String AUTH_SEPARATOR = ":";
    public static final String XSRF_TOKEN_HEADER = "X-XSRF-TOKEN";

    public static boolean hasAuthorizationHeader(Object credentialSource) {
        return credentialSource instanceof HttpServletRequest && StringUtils.hasText((String)((HttpServletRequest)credentialSource).getHeader("Authorization"));
    }

    public static AuthorizationHeader authorizationHeader(String authorization) {
        String tenant = null;
        String username = null;
        String password = null;
        if (authorization != null) {
            String[] loginAndPass = HttpRequestUtils.decode(authorization);
            tenant = null;
            username = loginAndPass.length > 0 ? loginAndPass[0] : "";
            password = loginAndPass.length > 1 ? loginAndPass[1] : "";
            String[] tenantAndUsername = HttpRequestUtils.splitUsername(username);
            if (tenantAndUsername.length > 1) {
                tenant = tenantAndUsername[0];
                username = tenantAndUsername[1];
            }
        }
        return AuthorizationHeader.builder().tenant(tenant).username(username).password(password).build();
    }

    public static String[] splitUsername(String username) {
        return username.split(LOGIN_SEPARATOR);
    }

    public static String[] decode(String authorization) {
        byte[] decoded = Base64.decode((byte[])authorization.substring(AUTH_PREFIX.length()).getBytes());
        return new String(decoded, StandardCharsets.UTF_8).split(AUTH_SEPARATOR, 2);
    }

    public static class AuthorizationHeader {
        private String tenant;
        private String username;
        private String password;

        @ConstructorProperties(value={"tenant", "username", "password"})
        AuthorizationHeader(String tenant, String username, String password) {
            this.tenant = tenant;
            this.username = username;
            this.password = password;
        }

        public static AuthorizationHeaderBuilder builder() {
            return new AuthorizationHeaderBuilder();
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setTenant(String tenant) {
            this.tenant = tenant;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthorizationHeader)) {
                return false;
            }
            AuthorizationHeader other = (AuthorizationHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tenant = this.getTenant();
            String other$tenant = other.getTenant();
            if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tenant = this.getTenant();
            result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        protected boolean canEqual(Object other) {
            return other instanceof AuthorizationHeader;
        }

        public String toString() {
            return "HttpRequestUtils.AuthorizationHeader(tenant=" + this.getTenant() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }

        public static class AuthorizationHeaderBuilder {
            private String tenant;
            private String username;
            private String password;

            AuthorizationHeaderBuilder() {
            }

            public AuthorizationHeaderBuilder tenant(String tenant) {
                this.tenant = tenant;
                return this;
            }

            public AuthorizationHeaderBuilder username(String username) {
                this.username = username;
                return this;
            }

            public AuthorizationHeaderBuilder password(String password) {
                this.password = password;
                return this;
            }

            public AuthorizationHeader build() {
                return new AuthorizationHeader(this.tenant, this.username, this.password);
            }

            public String toString() {
                return "HttpRequestUtils.AuthorizationHeader.AuthorizationHeaderBuilder(tenant=" + this.tenant + ", username=" + this.username + ", password=" + this.password + ")";
            }
        }
    }
}

