/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.filter.provider;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.MicroserviceCredentials;
import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.microservice.security.filter.provider.PostAuthorizationContextProvider;
import com.cumulocity.microservice.security.filter.util.HttpRequestUtils;
import com.cumulocity.microservice.subscription.service.MicroserviceSubscriptionsService;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;

public class SpringSecurityContextProvider
implements PostAuthorizationContextProvider<SecurityContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringSecurityContextProvider.class);
    private final ContextService<UserCredentials> userContext;
    private final MicroserviceSubscriptionsService subscriptionsService;
    private final String applicationName;

    @Override
    public boolean supports(SecurityContext context) {
        if (this.subscriptionsService == null) {
            log.warn("Context service not available.");
            return false;
        }
        if (context == null || context.getAuthentication() == null) {
            log.warn("Security context not available.");
            return false;
        }
        return context.getAuthentication().getPrincipal() instanceof UserDetails;
    }

    public MicroserviceCredentials get(SecurityContext context) {
        String tenant = this.getTenantName(context);
        if (StringUtils.hasText((String)tenant) && this.subscriptionsService != null) {
            Optional microservice = this.subscriptionsService.getCredentials(tenant);
            if (microservice.isPresent()) {
                return (MicroserviceCredentials)microservice.get();
            }
            throw new AccessDeniedException("Microservice " + this.applicationName + " is not subscribed by tenant " + tenant);
        }
        return null;
    }

    private String getTenantName(SecurityContext context) {
        UserDetails principal = (UserDetails)context.getAuthentication().getPrincipal();
        String[] split = HttpRequestUtils.splitUsername(principal.getUsername());
        if (split.length > 1) {
            return split[0];
        }
        if (this.userContext != null && this.userContext.isInContext()) {
            return ((UserCredentials)this.userContext.getContext()).getTenant();
        }
        return null;
    }

    @Generated
    public SpringSecurityContextProvider(ContextService<UserCredentials> userContext, MicroserviceSubscriptionsService subscriptionsService, String applicationName) {
        this.userContext = userContext;
        this.subscriptionsService = subscriptionsService;
        this.applicationName = applicationName;
    }
}

