/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.token;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.microservice.security.token.CumulocityOAuthMicroserviceFilter;
import com.cumulocity.microservice.security.token.JwtAuthenticatedTokenCache;
import com.cumulocity.microservice.security.token.JwtTokenAuthenticationProvider;
import com.cumulocity.microservice.security.token.OAuthPostAuthorizationContextProvider;
import com.cumulocity.microservice.subscription.service.MicroserviceSubscriptionsService;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.authentication.configuration.EnableGlobalAuthentication;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.context.request.RequestContextListener;

@Configuration(proxyBeanMethods=false)
public class CumulocityOAuthConfiguration
implements EnvironmentAware {
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Bean
    public OAuthPostAuthorizationContextProvider oAuthPostAuthorizationContextProvider(ObjectProvider<MicroserviceSubscriptionsService> subscriptionsService) {
        String applicationName = this.environment.getProperty("application.name", "");
        OAuthPostAuthorizationContextProvider provider = new OAuthPostAuthorizationContextProvider(applicationName);
        subscriptionsService.ifAvailable(provider::setSubscriptionsService);
        return provider;
    }

    @Bean
    public JwtTokenAuthenticationProvider jwtTokenAuthenticationProvider(JwtAuthenticatedTokenCache jwtAuthenticatedTokenCache) {
        return new JwtTokenAuthenticationProvider(this.environment, jwtAuthenticatedTokenCache);
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Configuration(proxyBeanMethods=false)
    static class FilterConfigurer {
        @Autowired
        private AuthenticationConfiguration authenticationConfiguration;
        @Autowired(required=false)
        private AuthenticationEntryPoint authenticationEntryPoint;
        @Autowired
        private ContextService<UserCredentials> userContextService;

        FilterConfigurer() {
        }

        @Bean
        public CumulocityOAuthMicroserviceFilter cumulocityOAuthMicroserviceFilter() throws Exception {
            return new CumulocityOAuthMicroserviceFilter(this.authenticationConfiguration.getAuthenticationManager(), this.authenticationEntryPoint, this.userContextService);
        }

        @Bean
        public FilterRegistrationBean<CumulocityOAuthMicroserviceFilter> cumulocityOAuthMicroserviceFilterRegistration(CumulocityOAuthMicroserviceFilter filter) {
            FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
            registration.setEnabled(false);
            return registration;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableGlobalAuthentication
    static class AuthenticationConfigurer {
        @Autowired
        private JwtTokenAuthenticationProvider jwtTokenAuthenticationProvider;

        AuthenticationConfigurer() {
        }

        @Autowired
        public void configureAuthenticationManager(AuthenticationManagerBuilder auth) {
            auth.authenticationProvider((AuthenticationProvider)this.jwtTokenAuthenticationProvider);
        }
    }
}

