/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.filter;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.security.filter.provider.PostAuthorizationContextProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class PostAuthenticateServletFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostAuthenticateServletFilter.class);
    private final List<PostAuthorizationContextProvider<SecurityContext>> credentialsResolvers;
    private final ContextService<Credentials> contextService;

    public PostAuthenticateServletFilter(List<PostAuthorizationContextProvider<SecurityContext>> credentialsResolvers, ContextService<Credentials> contextService) {
        this.credentialsResolvers = credentialsResolvers;
        this.contextService = contextService;
    }

    protected void doFilterInternal(final HttpServletRequest request, final HttpServletResponse response, final FilterChain filterChain) throws IOException, ServletException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                catch (Exception ex) {
                    Throwables.propagate((Throwable)ex);
                }
            }
        };
        if (this.contextService == null) {
            log.warn("Context service not available.");
        }
        if (this.contextService != null && this.credentialsResolvers != null) {
            try {
                ImmutableList credentials = FluentIterable.from(this.credentialsResolvers).filter((Predicate)new Predicate<PostAuthorizationContextProvider<SecurityContext>>(){

                    public boolean apply(PostAuthorizationContextProvider<SecurityContext> provider) {
                        return provider.supports(SecurityContextHolder.getContext());
                    }
                }).transform((Function)new Function<PostAuthorizationContextProvider<SecurityContext>, Credentials>(){

                    public Credentials apply(PostAuthorizationContextProvider<SecurityContext> provider) {
                        return provider.get(SecurityContextHolder.getContext());
                    }
                }).filter((Predicate)new Predicate<Credentials>(){

                    public boolean apply(Credentials credentials) {
                        return credentials != null;
                    }
                }).toList();
                for (Credentials credential : credentials) {
                    runnable = this.contextService.withinContext((Object)credential, runnable);
                }
            }
            catch (AccessDeniedException e) {
                this.sendAccessDenied(response, e.getMessage());
                return;
            }
        }
        runnable.run();
    }

    private void sendAccessDenied(HttpServletResponse response, String errorMessage) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(403);
        response.getWriter().write(this.toJsonError("Microservice/Access Denied", errorMessage));
    }

    private String toJsonError(String error, String message) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("error", error);
        node.put("message", message);
        return node.toString();
    }
}

