/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.token;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.microservice.security.token.CookieReader;
import com.cumulocity.microservice.security.token.JwtAndXsrfTokenCredentials;
import com.cumulocity.microservice.security.token.JwtCredentials;
import com.cumulocity.microservice.security.token.JwtOnlyCredentials;
import com.cumulocity.microservice.security.token.JwtTokenAuthentication;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class CumulocityOAuthMicroserviceFilter
extends GenericFilterBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CumulocityOAuthMicroserviceFilter.class);
    private final AuthenticationManager authenticationManager;
    private final AuthenticationEntryPoint authenticationEntryPoint;
    private final ContextService<UserCredentials> userContextService;

    public CumulocityOAuthMicroserviceFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint, ContextService<UserCredentials> userContextService) {
        this.authenticationManager = authenticationManager;
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.userContextService = userContextService;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Optional<JwtCredentials> jwtCredentials;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.shouldAuthenticate() && (jwtCredentials = this.readCredentials(request)).isPresent()) {
            boolean debug = this.logger.isDebugEnabled();
            try {
                JwtTokenAuthentication jwtTokenAuthentication = new JwtTokenAuthentication(jwtCredentials.get());
                Authentication authResult = this.authenticationManager.authenticate((Authentication)jwtTokenAuthentication);
                if (debug) {
                    this.logger.debug((Object)("Authentication success: " + authResult));
                }
                authResult.setAuthenticated(true);
                SecurityContextHolder.getContext().setAuthentication(authResult);
                this.userContextService.runWithinContext((Object)((JwtTokenAuthentication)authResult).getUserCredentials(), () -> {
                    try {
                        chain.doFilter(req, res);
                    }
                    catch (Exception e) {
                        throw new AuthenticationServiceException("Error on login attempt", (Throwable)e);
                    }
                });
                return;
            }
            catch (AuthenticationException failed) {
                log.warn("Error {}", (Throwable)failed);
                this.logger.warn((Object)failed);
                SecurityContextHolder.clearContext();
                if (debug) {
                    this.logger.debug((Object)("Authentication request for failed: " + failed));
                }
                this.authenticationEntryPoint.commence(request, response, failed);
                return;
            }
        }
        chain.doFilter(req, res);
    }

    private boolean shouldAuthenticate() {
        Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
        return existingAuth == null || !existingAuth.isAuthenticated();
    }

    private Optional<JwtCredentials> readCredentials(HttpServletRequest req) {
        String xsrfToken;
        Optional<Cookie> accessToken;
        Enumeration headers = req.getHeaders("Authorization");
        if (headers != null) {
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                if (!header.toLowerCase().startsWith("bearer")) continue;
                return Optional.of(new JwtOnlyCredentials(this.decodeAccessToken(header.substring(7))));
            }
        }
        if ((accessToken = CookieReader.readAuthorizationCookie(req)).isPresent() && !StringUtils.isEmpty((Object)(xsrfToken = req.getHeader("X-XSRF-TOKEN")))) {
            return Optional.of(new JwtAndXsrfTokenCredentials(this.decodeAccessToken(accessToken.get().getValue()), xsrfToken));
        }
        return Optional.empty();
    }

    private JWT decodeAccessToken(String accessToken) {
        try {
            return JWTParser.parse((String)accessToken);
        }
        catch (ParseException e) {
            log.error("Failed to parse access token", (Throwable)e);
            throw new AuthenticationServiceException("Authentication failed: could not parse access token", (Throwable)e);
        }
    }
}

