/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.filter;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.security.filter.provider.PreAuthorizationContextProvider;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class PreAuthenticateServletFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreAuthenticateServletFilter.class);
    private final List<PreAuthorizationContextProvider<HttpServletRequest>> credentialsResolvers;
    private final ContextService<Credentials> contextService;

    public PreAuthenticateServletFilter(List<PreAuthorizationContextProvider<HttpServletRequest>> credentialsResolvers, ContextService<Credentials> contextService) {
        this.credentialsResolvers = credentialsResolvers;
        this.contextService = contextService;
    }

    protected void doFilterInternal(final HttpServletRequest request, final HttpServletResponse response, final FilterChain filterChain) throws IOException, ServletException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                catch (Exception ex) {
                    Throwables.propagate((Throwable)ex);
                }
            }
        };
        if (this.contextService != null && this.credentialsResolvers != null && !this.contextService.isInContext()) {
            ImmutableList credentials = FluentIterable.from(this.credentialsResolvers).filter((Predicate)new Predicate<PreAuthorizationContextProvider<HttpServletRequest>>(){

                public boolean apply(PreAuthorizationContextProvider<HttpServletRequest> provider) {
                    return provider.supports(request);
                }
            }).transform((Function)new Function<PreAuthorizationContextProvider<HttpServletRequest>, Credentials>(){

                public Credentials apply(PreAuthorizationContextProvider<HttpServletRequest> provider) {
                    return provider.get(request);
                }
            }).filter((Predicate)new Predicate<Credentials>(){

                public boolean apply(Credentials credentials) {
                    return credentials != null;
                }
            }).toList();
            for (Credentials credential : credentials) {
                runnable = this.contextService.withinContext((Object)credential, runnable);
            }
        }
        runnable.run();
    }
}

