/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.service.impl;

import com.cumulocity.microservice.security.service.RoleService;
import com.cumulocity.rest.representation.user.CurrentUserRepresentation;
import com.cumulocity.rest.representation.user.RoleRepresentation;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.user.UserApi;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    private final UserApi userApi;

    public RoleServiceImpl(UserApi userApi) {
        this.userApi = userApi;
    }

    @Override
    public List<String> getUserRoles() {
        ArrayList result = Lists.newArrayList();
        try {
            CurrentUserRepresentation currrentUser = this.userApi.getCurrentUser();
            List effectiveRoles = currrentUser.getEffectiveRoles();
            if (effectiveRoles != null && !effectiveRoles.isEmpty()) {
                for (Object roleObject : effectiveRoles) {
                    if (roleObject instanceof Map) {
                        Map roleMap = (Map)roleObject;
                        result.add((String)roleMap.get("name"));
                        continue;
                    }
                    if (roleObject instanceof RoleRepresentation) {
                        RoleRepresentation role = (RoleRepresentation)roleObject;
                        result.add(role.getName());
                        continue;
                    }
                    throw new IllegalStateException("user/currentUser response body is not parsable");
                }
            }
        }
        catch (SDKException e) {
            if (e.getHttpStatus() != HttpStatus.FORBIDDEN.value()) {
                throw e;
            }
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
        return result;
    }
}

