/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.token;

import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.microservice.security.token.JwtCredentials;
import com.cumulocity.rest.representation.user.CurrentUserRepresentation;
import com.cumulocity.rest.representation.user.RoleRepresentation;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class JwtTokenAuthentication
implements Authentication {
    private final JwtCredentials jwtCredentials;
    private boolean authenticated;
    private CurrentUserRepresentation currentUserRepresentation;
    private UserCredentials userCredentials;
    private final Supplier<Collection> memoizedAuthorities = Suppliers.memoize((Supplier)new Supplier<Collection>(){

        public Collection get() {
            return Collections2.transform((Collection)JwtTokenAuthentication.this.currentUserRepresentation.getEffectiveRoles(), (Function)new Function<RoleRepresentation, GrantedAuthority>(){

                public GrantedAuthority apply(RoleRepresentation roleRepresentation) {
                    return new SimpleGrantedAuthority(roleRepresentation.getName());
                }
            });
        }
    });

    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.currentUserRepresentation != null) {
            return (Collection)this.memoizedAuthorities.get();
        }
        return Collections.emptyList();
    }

    public JwtCredentials getCredentials() {
        return this.jwtCredentials;
    }

    public Object getDetails() {
        return null;
    }

    public Object getPrincipal() {
        return this.getUserName();
    }

    public String getName() {
        String tenantName = this.getTenantName();
        String userName = this.getUserName();
        if (userName != null && tenantName != null) {
            return tenantName + "/" + userName;
        }
        return userName;
    }

    private String getUserName() {
        return this.currentUserRepresentation != null ? this.currentUserRepresentation.getUserName() : null;
    }

    String getTenantName() {
        return this.userCredentials == null ? null : this.userCredentials.getTenant();
    }

    @Generated
    public JwtTokenAuthentication(JwtCredentials jwtCredentials) {
        this.jwtCredentials = jwtCredentials;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtTokenAuthentication)) {
            return false;
        }
        JwtTokenAuthentication other = (JwtTokenAuthentication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JwtCredentials this$jwtCredentials = this.jwtCredentials;
        JwtCredentials other$jwtCredentials = other.jwtCredentials;
        return !(this$jwtCredentials == null ? other$jwtCredentials != null : !this$jwtCredentials.equals(other$jwtCredentials));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JwtTokenAuthentication;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JwtCredentials $jwtCredentials = this.jwtCredentials;
        result = result * 59 + ($jwtCredentials == null ? 43 : $jwtCredentials.hashCode());
        return result;
    }

    @Generated
    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    @Generated
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Generated
    public void setCurrentUserRepresentation(CurrentUserRepresentation currentUserRepresentation) {
        this.currentUserRepresentation = currentUserRepresentation;
    }

    @Generated
    public CurrentUserRepresentation getCurrentUserRepresentation() {
        return this.currentUserRepresentation;
    }

    @Generated
    public void setUserCredentials(UserCredentials userCredentials) {
        this.userCredentials = userCredentials;
    }

    @Generated
    public UserCredentials getUserCredentials() {
        return this.userCredentials;
    }
}

