/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.service.impl;

import com.cumulocity.microservice.security.service.SecurityExpressionService;
import com.cumulocity.microservice.security.service.SecurityUserDetails;
import com.cumulocity.microservice.subscription.repository.application.ApplicationApi;
import java.util.Objects;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Lazy
@Service(value="c8yAuthz")
public class SecurityExpressionServiceImpl
implements SecurityExpressionService {
    private final ApplicationApi applicationApi;
    @Value(value="${securityContext.tenantManagementId:management}")
    private String managementId;

    @Override
    public boolean isFeatureEnabled(String featureName) {
        return this.applicationApi.getByName(featureName).isPresent();
    }

    @Override
    public boolean isServiceUser(String service) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Object principal = authentication.getPrincipal();
        if (principal instanceof UserDetails) {
            String username = ((UserDetails)principal).getUsername();
            return Objects.equals(username, "service_" + service);
        }
        return false;
    }

    @Override
    public boolean isCurrentTenantManagement() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Object principal = authentication.getPrincipal();
        if (principal instanceof SecurityUserDetails) {
            String tenant = ((SecurityUserDetails)principal).getTenant();
            return this.managementId.equals(tenant);
        }
        return false;
    }

    @Generated
    public SecurityExpressionServiceImpl(ApplicationApi applicationApi) {
        this.applicationApi = applicationApi;
    }
}

