/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.token;

import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.microservice.security.token.JwtCredentials;
import com.cumulocity.microservice.security.token.JwtTokenAuthentication;
import com.nimbusds.jwt.JWT;
import java.util.Objects;

public class JwtOnlyCredentials
implements JwtCredentials {
    private final JWT jwt;

    public JwtOnlyCredentials(JWT jwt) {
        this.jwt = jwt;
    }

    @Override
    public JWT getJwt() {
        return this.jwt;
    }

    @Override
    public UserCredentials toUserCredentials(String tenantName, JwtTokenAuthentication jwtTokenAuthentication) {
        return UserCredentials.builder().tenant(tenantName).username(jwtTokenAuthentication.getCurrentUserRepresentation().getUserName()).oAuthAccessToken(jwtTokenAuthentication.getCredentials().getJwt().serialize()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JwtOnlyCredentials that = (JwtOnlyCredentials)o;
        return Objects.equals(this.jwt.serialize(), that.jwt.serialize());
    }

    public int hashCode() {
        return Objects.hash(this.jwt.serialize());
    }
}

