/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.token;

import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.microservice.security.token.JwtCredentials;
import com.cumulocity.microservice.security.token.JwtTokenAuthentication;
import com.nimbusds.jwt.JWT;
import java.util.Objects;

public class JwtAndXsrfTokenCredentials
implements JwtCredentials {
    private final JWT jwt;
    private final String xsrfToken;

    public JwtAndXsrfTokenCredentials(JWT jwt, String xsrfToken) {
        this.jwt = jwt;
        this.xsrfToken = xsrfToken;
    }

    @Override
    public JWT getJwt() {
        return this.jwt;
    }

    @Override
    public UserCredentials toUserCredentials(String tenantName, JwtTokenAuthentication jwtTokenAuthentication) {
        JwtAndXsrfTokenCredentials credentials = (JwtAndXsrfTokenCredentials)jwtTokenAuthentication.getCredentials();
        return UserCredentials.builder().tenant(tenantName).username(jwtTokenAuthentication.getCurrentUserRepresentation().getUserName()).oAuthAccessToken(credentials.getJwt().serialize()).xsrfToken(credentials.getXsrfToken()).build();
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JwtAndXsrfTokenCredentials that = (JwtAndXsrfTokenCredentials)o;
        return Objects.equals(this.jwt.serialize(), that.jwt.serialize()) && Objects.equals(this.xsrfToken, that.xsrfToken);
    }

    public int hashCode() {
        return Objects.hash(this.jwt.serialize(), this.xsrfToken);
    }
}

