/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.token;

import com.cumulocity.microservice.security.token.CumulocityCoreAuthenticationClient;
import com.cumulocity.microservice.security.token.JwtAuthenticatedTokenCache;
import com.cumulocity.microservice.security.token.JwtCredentials;
import com.cumulocity.microservice.security.token.JwtTokenAuthentication;
import com.cumulocity.microservice.security.token.JwtTokenAuthenticationLoader;
import com.cumulocity.microservice.security.token.TokenCacheException;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.SpringSecurityMessageSource;

public class JwtTokenAuthenticationProvider
implements AuthenticationProvider,
MessageSourceAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtTokenAuthenticationProvider.class);
    protected MessageSourceAccessor messages;
    private final Environment environment;
    private final JwtAuthenticatedTokenCache tokenCache;

    public JwtTokenAuthenticationProvider(Environment environment, JwtAuthenticatedTokenCache tokenCache) {
        this.environment = environment;
        this.tokenCache = tokenCache;
        this.messages = SpringSecurityMessageSource.getAccessor();
    }

    public boolean supports(Class<?> authentication) {
        return JwtTokenAuthentication.class.isAssignableFrom(authentication);
    }

    public Authentication authenticate(Authentication authentication) {
        final JwtTokenAuthentication jwtTokenAuthentication = (JwtTokenAuthentication)authentication;
        JwtCredentials jwtCredentials = jwtTokenAuthentication.getCredentials();
        try {
            return this.tokenCache.get(jwtCredentials, new JwtTokenAuthenticationLoader(){

                @Override
                public JwtTokenAuthentication call() {
                    String baseUrl = JwtTokenAuthenticationProvider.this.environment.getProperty("C8Y.baseURL");
                    return CumulocityCoreAuthenticationClient.authenticateUserAndUpdateToken(baseUrl, jwtTokenAuthentication);
                }
            });
        }
        catch (ExecutionException e) {
            throw new TokenCacheException("Problem with token cache.", e);
        }
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }
}

