/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.configuration;

import com.cumulocity.microservice.security.configuration.MicroserviceWebSecurityCustomizer;
import com.cumulocity.microservice.security.filter.PostAuthenticateServletFilter;
import com.cumulocity.microservice.security.filter.PreAuthenticateServletFilter;
import com.cumulocity.microservice.security.filter.PrePostFiltersConfiguration;
import com.cumulocity.microservice.security.token.CumulocityOAuthConfiguration;
import com.cumulocity.microservice.security.token.CumulocityOAuthMicroserviceFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Order(value=99)
@Configuration(proxyBeanMethods=false)
@EnableWebSecurity
@Import(value={CumulocityOAuthConfiguration.class, PrePostFiltersConfiguration.class})
public class WebSecurityConfiguration {
    @Autowired
    private UserDetailsService userDetailsService;
    @Value(value="${management.security.roles:TENANT_MANAGEMENT_ADMIN}")
    private String[] securityRolesLoggersActuator;

    @Autowired
    public void configureAuthenticationManager(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userDetailsService);
    }

    @Bean
    public static PasswordEncoder passwordEncoder() {
        return NoOpPasswordEncoder.getInstance();
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http, HandlerMappingIntrospector introspector, ServerProperties serverProperties, CumulocityOAuthMicroserviceFilter cumulocityOAuthMicroserviceFilter, PreAuthenticateServletFilter preAuthenticateServletFilter, PostAuthenticateServletFilter postAuthenticateServletFilter, ObjectProvider<MicroserviceWebSecurityCustomizer> microserviceWebSecurityCustomizer) throws Exception {
        if (this.securityRolesLoggersActuator.length == 0) {
            this.securityRolesLoggersActuator = new String[]{"TENANT_MANAGEMENT_ADMIN"};
        }
        MvcRequestMatcher.Builder mvc = new MvcRequestMatcher.Builder(introspector).servletPath(serverProperties.getServlet().getContextPath());
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.dispatcherTypeMatchers(new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.ERROR})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern("/metadata")})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern("/health")})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern("/prometheus")})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern("/metrics")})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern("/version")})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern(HttpMethod.POST, "/loggers/*")})).hasAnyRole(this.securityRolesLoggersActuator).requestMatchers(new RequestMatcher[]{mvc.pattern(HttpMethod.POST, "/loggers")})).hasAnyRole(this.securityRolesLoggersActuator).anyRequest()).fullyAuthenticated()).httpBasic(Customizer.withDefaults()).csrf(AbstractHttpConfigurer::disable).securityContext(AbstractHttpConfigurer::disable).sessionManagement(AbstractHttpConfigurer::disable).requestCache(AbstractHttpConfigurer::disable);
        http.addFilterBefore((Filter)cumulocityOAuthMicroserviceFilter, BasicAuthenticationFilter.class);
        http.addFilterBefore((Filter)preAuthenticateServletFilter, BasicAuthenticationFilter.class);
        http.addFilterAfter((Filter)postAuthenticateServletFilter, AnonymousAuthenticationFilter.class);
        microserviceWebSecurityCustomizer.ifAvailable(customizer -> customizer.customize(http));
        return (SecurityFilterChain)http.build();
    }
}

