/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.service;

import com.cumulocity.microservice.security.service.RoleService;
import com.cumulocity.microservice.security.service.SecurityUserDetails;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Repository;

@Repository
public class SecurityUserDetailsService
implements UserDetailsService {
    private final CumulocityCredentials userCredentials;
    private final RoleService roleService;
    private final Cache<CumulocityCredentials, UserDetails> userDetails = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors() * 2).expireAfterWrite(10L, TimeUnit.SECONDS).build();

    public SecurityUserDetailsService(CumulocityCredentials userCredentials, RoleService roleService) {
        this.userCredentials = userCredentials;
        this.roleService = roleService;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        final CumulocityCredentials credentials = this.userCredentials.copy();
        try {
            return (UserDetails)this.userDetails.get((Object)credentials, (Callable)new Callable<UserDetails>(){

                @Override
                public UserDetails call() {
                    return SecurityUserDetails.activeUser(SecurityUserDetailsService.this.roleService.getUserRoles()).credentials(credentials).build();
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

