/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.service;

import com.cumulocity.model.authentication.CumulocityBasicCredentials;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.model.authentication.CumulocityCredentialsFactory;
import com.cumulocity.model.authentication.CumulocityOAuthCredentials;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityUserDetails
implements UserDetails {
    private Collection<? extends GrantedAuthority> authorities;
    private CumulocityCredentials credentials;
    private boolean accountNonExpired;
    private boolean accountNonLocked;
    private boolean credentialsNonExpired;
    private boolean enabled;

    @ConstructorProperties(value={"authorities", "tenant", "password", "username", "oAuthAccessToken", "xsrfToken", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    SecurityUserDetails(Collection<? extends GrantedAuthority> authorities, String tenant, String password, String username, String oAuthAccessToken, String xsrfToken, boolean accountNonExpired, boolean accountNonLocked, boolean credentialsNonExpired, boolean enabled) {
        this.credentials = new CumulocityCredentialsFactory().withOAuthAccessToken(oAuthAccessToken).withXsrfToken(xsrfToken).withTenant(tenant).withUsername(username).withPassword(password).getCredentials();
        this.authorities = authorities;
        this.accountNonExpired = accountNonExpired;
        this.accountNonLocked = accountNonLocked;
        this.credentialsNonExpired = credentialsNonExpired;
        this.enabled = enabled;
    }

    private SecurityUserDetails(Collection<? extends GrantedAuthority> authorities, CumulocityCredentials credentials, boolean accountNonExpired, boolean accountNonLocked, boolean credentialsNonExpired, boolean enabled) {
        this.credentials = credentials;
        this.authorities = authorities;
        this.accountNonExpired = accountNonExpired;
        this.accountNonLocked = accountNonLocked;
        this.credentialsNonExpired = credentialsNonExpired;
        this.enabled = enabled;
    }

    public static SecurityUserDetails activeUser(String tenant, String username, String password, String ... userRoles) {
        return SecurityUserDetails.activeUser(tenant, username, password, Lists.newArrayList((Object[])userRoles));
    }

    public static SecurityUserDetails activeUser(String tenant, String username, String password, Iterable<String> userRoles) {
        return SecurityUserDetails.activeUser(userRoles).credentials((CumulocityCredentials)CumulocityBasicCredentials.builder().tenantId(tenant).username(username).password(password).build()).build();
    }

    public static SecurityUserDetailsBuilder activeUser(Iterable<String> userRoles) {
        SecurityUserDetailsBuilder result = SecurityUserDetails.builder().accountNonExpired(true).accountNonLocked(true).credentialsNonExpired(true).enabled(true);
        for (String userRole : userRoles) {
            result.authority((GrantedAuthority)new SimpleGrantedAuthority(userRole));
        }
        return result;
    }

    public static SecurityUserDetailsBuilder builder() {
        return new SecurityUserDetailsBuilder();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getTenant() {
        return this.credentials.getTenantId();
    }

    public String getPassword() {
        if (this.credentials instanceof CumulocityBasicCredentials) {
            return ((CumulocityBasicCredentials)this.credentials).getPassword();
        }
        throw new IllegalStateException();
    }

    public String getUsername() {
        return this.credentials.getUsername();
    }

    public String getOAuthAccessToken() {
        if (this.credentials instanceof CumulocityOAuthCredentials) {
            return ((CumulocityOAuthCredentials)this.credentials).getAccessToken();
        }
        throw new IllegalStateException();
    }

    public String getXsrfToken() {
        if (this.credentials instanceof CumulocityOAuthCredentials) {
            return ((CumulocityOAuthCredentials)this.credentials).getXsrfToken();
        }
        throw new IllegalStateException();
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityUserDetails)) {
            return false;
        }
        SecurityUserDetails that = (SecurityUserDetails)o;
        return this.accountNonExpired == that.accountNonExpired && this.accountNonLocked == that.accountNonLocked && this.credentialsNonExpired == that.credentialsNonExpired && this.enabled == that.enabled && Objects.equals(this.authorities, that.authorities) && Objects.equals(this.credentials, that.credentials);
    }

    public int hashCode() {
        return Objects.hash(this.authorities, this.credentials, this.accountNonExpired, this.accountNonLocked, this.credentialsNonExpired, this.enabled);
    }

    public String toString() {
        return "SecurityUserDetails{authorities=" + this.authorities + ", credentials=" + this.credentials + ", accountNonExpired=" + this.accountNonExpired + ", accountNonLocked=" + this.accountNonLocked + ", credentialsNonExpired=" + this.credentialsNonExpired + ", enabled=" + this.enabled + "}";
    }

    public static class SecurityUserDetailsBuilder {
        private ArrayList<GrantedAuthority> authorities;
        private CumulocityCredentials credentials;
        private boolean accountNonExpired;
        private boolean accountNonLocked;
        private boolean credentialsNonExpired;
        private boolean enabled;

        SecurityUserDetailsBuilder() {
        }

        public SecurityUserDetailsBuilder authority(GrantedAuthority authority) {
            if (this.authorities == null) {
                this.authorities = new ArrayList();
            }
            this.authorities.add(authority);
            return this;
        }

        public SecurityUserDetailsBuilder authorities(Collection<? extends GrantedAuthority> authorities) {
            if (this.authorities == null) {
                this.authorities = new ArrayList();
            }
            this.authorities.addAll(authorities);
            return this;
        }

        public SecurityUserDetailsBuilder clearAuthorities() {
            if (this.authorities != null) {
                this.authorities.clear();
            }
            return this;
        }

        public SecurityUserDetailsBuilder credentials(CumulocityCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public SecurityUserDetailsBuilder accountNonExpired(boolean accountNonExpired) {
            this.accountNonExpired = accountNonExpired;
            return this;
        }

        public SecurityUserDetailsBuilder accountNonLocked(boolean accountNonLocked) {
            this.accountNonLocked = accountNonLocked;
            return this;
        }

        public SecurityUserDetailsBuilder credentialsNonExpired(boolean credentialsNonExpired) {
            this.credentialsNonExpired = credentialsNonExpired;
            return this;
        }

        public SecurityUserDetailsBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public SecurityUserDetails build() {
            return new SecurityUserDetails(switch (this.authorities == null ? 0 : this.authorities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.authorities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<GrantedAuthority>(this.authorities));
            }, this.credentials, this.accountNonExpired, this.accountNonLocked, this.credentialsNonExpired, this.enabled);
        }

        public String toString() {
            return "SecurityUserDetails.SecurityUserDetailsBuilder(authorities=" + this.authorities + ", tenant=" + this.credentials.getTenantId() + ", credentials=" + this.credentials + ", accountNonExpired=" + this.accountNonExpired + ", accountNonLocked=" + this.accountNonLocked + ", credentialsNonExpired=" + this.credentialsNonExpired + ", enabled=" + this.enabled + ")";
        }
    }
}

