/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.token;

import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.microservice.security.token.JwtAndXsrfTokenCredentials;
import com.cumulocity.microservice.security.token.JwtCredentials;
import com.cumulocity.microservice.security.token.JwtTokenAuthentication;
import com.cumulocity.model.authentication.AuthenticationMethod;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.model.authentication.CumulocityOAuthCredentials;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.rest.representation.user.CurrentUserRepresentation;
import com.cumulocity.rest.representation.user.UserMediaType;
import com.cumulocity.sdk.client.CumulocityAuthenticationFilter;
import com.cumulocity.sdk.client.rest.mediatypes.ErrorMessageRepresentationReader;
import com.cumulocity.sdk.client.rest.providers.CumulocityJSONMessageBodyReader;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import lombok.Generated;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.client.ClientConfig;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

class CumulocityCoreAuthenticationClient {
    private static final int CONNECTION_TIMEOUT = 30000;

    CumulocityCoreAuthenticationClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JwtTokenAuthentication authenticateUserAndUpdateToken(String baseUrl, JwtTokenAuthentication jwtTokenAuthentication) {
        try (Client client = CumulocityCoreAuthenticationClient.createClient(jwtTokenAuthentication);){
            CurrentUserRepresentation currUserRepresentation = CumulocityCoreAuthenticationClient.getCurrentUser(client, baseUrl);
            String tenantName = CumulocityCoreAuthenticationClient.getTenantName(client, baseUrl);
            jwtTokenAuthentication.setCurrentUserRepresentation(currUserRepresentation);
            JwtTokenAuthentication jwtTokenAuthentication2 = CumulocityCoreAuthenticationClient.updateUserCredentials(tenantName, jwtTokenAuthentication);
            return jwtTokenAuthentication2;
        }
    }

    public static Client createClient(JwtTokenAuthentication jwtTokenAuthentication) {
        HttpServletRequest request;
        RequestAttributes attributes;
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)CumulocityCoreAuthenticationClient.createClientConfig());
        if (jwtTokenAuthentication != null) {
            clientBuilder.register((Object)CumulocityCoreAuthenticationClient.createClientWithAuthenticationFilter(jwtTokenAuthentication));
        }
        if ((attributes = RequestContextHolder.getRequestAttributes()) instanceof ServletRequestAttributes && (request = ((ServletRequestAttributes)attributes).getRequest()) != null) {
            clientBuilder.register((Object)new ForwardedHeaderOnRequestFilter(request));
        }
        return clientBuilder.build();
    }

    private static CumulocityAuthenticationFilter createClientWithAuthenticationFilter(JwtTokenAuthentication jwtTokenAuthentication) {
        JwtCredentials jwtCredentials = jwtTokenAuthentication.getCredentials();
        if (jwtCredentials instanceof JwtAndXsrfTokenCredentials) {
            JwtAndXsrfTokenCredentials jwtAndXsrfCred = (JwtAndXsrfTokenCredentials)jwtCredentials;
            return new CumulocityAuthenticationFilter((CumulocityCredentials)CumulocityOAuthCredentials.builder().authenticationMethod(AuthenticationMethod.COOKIE).oAuthAccessToken(jwtAndXsrfCred.getJwt().serialize()).xsrfToken(jwtAndXsrfCred.getXsrfToken()).build());
        }
        return new CumulocityAuthenticationFilter((CumulocityCredentials)CumulocityOAuthCredentials.builder().authenticationMethod(AuthenticationMethod.HEADER).oAuthAccessToken(jwtCredentials.getJwt().serialize()).build());
    }

    private static ClientConfig createClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(CumulocityJSONMessageBodyReader.class);
        clientConfig.register(ErrorMessageRepresentationReader.class);
        clientConfig.property("jersey.config.apache.client.connectionManager", (Object)new PoolingHttpClientConnectionManager());
        clientConfig.property("jersey.config.client.connectTimeout", (Object)30000);
        return clientConfig;
    }

    private static CurrentUserRepresentation getCurrentUser(Client client, String baseUrl) {
        return (CurrentUserRepresentation)client.target(baseUrl + "/user/currentUser").request(new MediaType[]{UserMediaType.CURRENT_USER}).get(CurrentUserRepresentation.class);
    }

    private static String getTenantName(Client client, String baseUrl) {
        SimplifiedCurrentTenantRepresentation currentTenantRepresentation = (SimplifiedCurrentTenantRepresentation)((Object)client.target(baseUrl + "/tenant/currentTenant").request(new MediaType[]{UserMediaType.CURRENT_TENANT}).get(SimplifiedCurrentTenantRepresentation.class));
        return currentTenantRepresentation.name;
    }

    static JwtTokenAuthentication updateUserCredentials(String tenantName, JwtTokenAuthentication jwtTokenAuthentication) {
        UserCredentials userCredentials = CumulocityCoreAuthenticationClient.buildUserCredentials(tenantName, jwtTokenAuthentication);
        jwtTokenAuthentication.setUserCredentials(userCredentials);
        return jwtTokenAuthentication;
    }

    private static UserCredentials buildUserCredentials(String tenantName, JwtTokenAuthentication jwtTokenAuthentication) {
        JwtCredentials jwtCredentials = jwtTokenAuthentication.getCredentials();
        return jwtCredentials.toUserCredentials(tenantName, jwtTokenAuthentication);
    }

    @Provider
    static class ForwardedHeaderOnRequestFilter
    implements ClientRequestFilter {
        private static final String X_Forwarded_Host = "X-Forwarded-Host";
        private final HttpServletRequest request;

        public void filter(ClientRequestContext clientRequestContext) throws IOException {
            clientRequestContext.getHeaders().add((Object)X_Forwarded_Host, (Object)this.request.getHeader(X_Forwarded_Host));
        }

        @Generated
        public ForwardedHeaderOnRequestFilter(HttpServletRequest request) {
            this.request = request;
        }
    }

    public static class SimplifiedCurrentTenantRepresentation
    extends AbstractExtensibleRepresentation {
        private String name;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }
    }
}

