/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.configuration;

import com.cumulocity.microservice.security.token.JwtAuthenticatedTokenCache;
import com.cumulocity.microservice.security.token.JwtTokenAuthenticationGuavaCache;
import com.cumulocity.microservice.settings.annotation.EnableTenantOptionSettingsConfiguration;
import com.cumulocity.microservice.settings.service.MicroserviceSettingsService;
import com.google.common.primitives.Ints;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={EnableTenantOptionSettingsConfiguration.class})
public class TokenCacheConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenCacheConfiguration.class);
    private final Optional<MicroserviceSettingsService> settingsService;

    public TokenCacheConfiguration(Optional<MicroserviceSettingsService> settingsService) {
        this.settingsService = settingsService;
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtAuthenticatedTokenCache jwtAuthenticatedTokenCache(@Value(value="${cache.guava.maxSize:10000}") int jwtGuavaCacheMaxSize, @Value(value="${cache.guava.expireAfterAccessInMinutes:10}") int jwtGuavaCacheExpireAfterAccess, @Value(value="${jwt.cache.guava.expireInSeconds:0}") int jwtCacheExpireInSeconds) {
        int cacheMaxSize = this.settingsService.map(it -> it.get("cache.guava.maxSize")).map(Ints::tryParse).orElse(jwtGuavaCacheMaxSize);
        int cacheExpireAfterAccess = this.settingsService.map(it -> it.get("cache.guava.expireAfterAccessInMinutes")).map(Ints::tryParse).orElse(jwtGuavaCacheExpireAfterAccess);
        int jwtCacheExpire = this.settingsService.map(it -> it.get("jwt.cache.guava.expireInSeconds")).map(Ints::tryParse).orElse(jwtCacheExpireInSeconds);
        log.info("Default Guava implementation for token cache is used.\nParameters:\n- max cache size: " + cacheMaxSize + "\n- expire after access: " + cacheExpireAfterAccess + " minutes. Expire after write " + jwtCacheExpire + " seconds");
        return new JwtTokenAuthenticationGuavaCache(cacheMaxSize, cacheExpireAfterAccess, jwtCacheExpire);
    }
}

