/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.filter;

import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.microservice.security.filter.PostAuthenticateServletFilter;
import com.cumulocity.microservice.security.filter.PreAuthenticateServletFilter;
import com.cumulocity.microservice.security.filter.provider.HttpContextProvider;
import com.cumulocity.microservice.security.filter.provider.PostAuthorizationContextProvider;
import com.cumulocity.microservice.security.filter.provider.PreAuthorizationContextProvider;
import com.cumulocity.microservice.security.filter.provider.SpringSecurityContextProvider;
import com.cumulocity.microservice.subscription.service.MicroserviceSubscriptionsService;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.security.core.context.SecurityContext;

@Configuration(proxyBeanMethods=false)
public class PrePostFiltersConfiguration
implements EnvironmentAware {
    private PropertyResolver propertyResolver;
    @Autowired
    private ContextService<Credentials> contextService;
    @Autowired
    private ContextService<UserCredentials> userContext;
    @Autowired
    private MicroserviceSubscriptionsService subscriptionsService;

    public void setEnvironment(Environment environment) {
        this.propertyResolver = environment;
    }

    @Bean
    public HttpContextProvider httpContextProvider() {
        return new HttpContextProvider();
    }

    @Bean
    public SpringSecurityContextProvider springSecurityContextProvider() {
        return new SpringSecurityContextProvider(this.userContext, this.subscriptionsService, this.propertyResolver.getProperty("application.name", ""));
    }

    @Bean
    public PreAuthenticateServletFilter preAuthenticateServletFilter(List<PreAuthorizationContextProvider<HttpServletRequest>> credentialsResolvers) {
        return new PreAuthenticateServletFilter(credentialsResolvers, this.contextService);
    }

    @Bean
    public FilterRegistrationBean<PreAuthenticateServletFilter> preAuthenticateFilterRegistration(PreAuthenticateServletFilter filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registration.setEnabled(false);
        return registration;
    }

    @Bean
    public PostAuthenticateServletFilter postAuthenticateServletFilter(List<PostAuthorizationContextProvider<SecurityContext>> credentialsResolvers) {
        return new PostAuthenticateServletFilter(credentialsResolvers, this.contextService);
    }

    @Bean
    public FilterRegistrationBean<PostAuthenticateServletFilter> postAuthenticateFilterRegistration(PostAuthenticateServletFilter filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registration.setEnabled(false);
        return registration;
    }
}

