/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.token;

import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.security.filter.provider.PostAuthorizationContextProvider;
import com.cumulocity.microservice.security.token.JwtTokenAuthentication;
import com.cumulocity.microservice.subscription.service.MicroserviceSubscriptionsService;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.util.StringUtils;

class OAuthPostAuthorizationContextProvider
implements PostAuthorizationContextProvider<SecurityContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuthPostAuthorizationContextProvider.class);
    private final String applicationName;
    private MicroserviceSubscriptionsService subscriptionsService;

    public OAuthPostAuthorizationContextProvider(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setSubscriptionsService(MicroserviceSubscriptionsService subscriptionsService) {
        this.subscriptionsService = subscriptionsService;
    }

    @Override
    public boolean supports(SecurityContext securityContext) {
        if (this.subscriptionsService == null) {
            log.warn("Subscription service not available.");
            return false;
        }
        if (securityContext == null || securityContext.getAuthentication() == null) {
            log.warn("Security context not available.");
            return false;
        }
        return securityContext.getAuthentication() instanceof JwtTokenAuthentication;
    }

    @Override
    public Credentials get(SecurityContext context) {
        Optional<String> tenant = this.getTenantName(context);
        if (tenant.isPresent() && this.subscriptionsService != null) {
            Optional microservice = this.subscriptionsService.getCredentials(tenant.get());
            if (microservice.isPresent()) {
                return (Credentials)microservice.get();
            }
            throw new AccessDeniedException("Microservice " + this.applicationName + " is not subscribed by tenant " + tenant.get());
        }
        return null;
    }

    private Optional<String> getTenantName(SecurityContext context) {
        JwtTokenAuthentication jwtTokenAuthentication = (JwtTokenAuthentication)context.getAuthentication();
        String tenantName = jwtTokenAuthentication.getTenantName();
        return StringUtils.hasText((String)tenantName) ? Optional.of(tenantName) : Optional.empty();
    }
}

