/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.security.filter.provider;

import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.microservice.security.filter.provider.PreAuthorizationContextProvider;
import com.cumulocity.microservice.security.filter.util.HttpRequestUtils;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class HttpContextProvider
implements PreAuthorizationContextProvider<HttpServletRequest> {
    public UserCredentials get(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        String applicationKey = request.getHeader("X-Cumulocity-Application-Key");
        String tfaToken = request.getHeader("TFAToken");
        HttpRequestUtils.AuthorizationHeader from = HttpRequestUtils.authorizationHeader(authorization);
        if (StringUtils.hasText((String)from.getTenant())) {
            return UserCredentials.builder().tenant(from.getTenant()).username(from.getUsername()).password(from.getPassword()).oAuthAccessToken(this.obtainOAuthAccessToken(request)).xsrfToken(request.getHeader("X-XSRF-TOKEN")).appKey(applicationKey).tfaToken(tfaToken).build();
        }
        return null;
    }

    private String obtainOAuthAccessToken(HttpServletRequest request) {
        if (request == null || request.getCookies() == null) {
            return null;
        }
        Optional<Cookie> cookieOptional = Arrays.stream(request.getCookies()).filter(cookie -> "Authorization".equalsIgnoreCase(cookie.getName())).findFirst();
        return cookieOptional.map(Cookie::getValue).orElse(null);
    }

    @Override
    public boolean supports(HttpServletRequest credentialSource) {
        return HttpRequestUtils.hasAuthorizationHeader(credentialSource);
    }
}

