/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.properties;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.springframework.boot.DefaultPropertiesPropertySource;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

@Order
public class MicroserviceDefaultPropertiesRegistrar
implements EnvironmentPostProcessor {
    public static final String MICROSERVICE_DEFAULT_PROPERTIES_LOCATION = "classpath:microservice_default.properties";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Properties properties = MicroserviceDefaultPropertiesRegistrar.loadProperties(application.getClassLoader());
        Map<String, Object> propertiesMap = properties.entrySet().stream().collect(Collectors.toMap(p -> String.valueOf(p.getKey()), Map.Entry::getValue));
        DefaultPropertiesPropertySource.addOrMerge(propertiesMap, (MutablePropertySources)environment.getPropertySources());
    }

    private static Properties loadProperties(ClassLoader classLoader) {
        try {
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader(classLoader);
            Resource resource = resourceLoader.getResource(MICROSERVICE_DEFAULT_PROPERTIES_LOCATION);
            return PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load microservice default properties", e);
        }
    }
}

