/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.properties;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;
import org.springframework.core.env.Environment;

public class ConfigurationFileProvider {
    public static final String PACKAGE_DIRECTORY = "${package.directory:${application.name:'application'}}";
    private final Environment environment;

    public Iterable<Path> find(String ... suffix) {
        String packageDirectory = this.resolveDirectory();
        String fileName = this.environment.getProperty("package.name", packageDirectory);
        return this.find(new String[]{fileName}, suffix);
    }

    private String resolveDirectory() {
        return this.environment.resolvePlaceholders(PACKAGE_DIRECTORY);
    }

    public Iterable<Path> find(final String[] fileNames, String ... suffix) {
        ImmutableList files = FluentIterable.from((Object[])suffix).transformAndConcat((Function)new Function<String, Iterable<String>>(){

            public Iterable<String> apply(final String suffix) {
                return FluentIterable.from((Object[])fileNames).transform((Function)new Function<String, String>(){

                    public String apply(String fileName) {
                        return fileName + suffix;
                    }
                });
            }
        }).toList();
        return FluentIterable.from(this.directories()).transformAndConcat((Function)new Function<Path, Iterable<Path>>(){
            final /* synthetic */ List val$files;
            {
                this.val$files = list;
            }

            public Iterable<Path> apply(final Path fileSupplier) {
                return FluentIterable.from((Iterable)this.val$files).transform((Function)new Function<String, Path>(){

                    public Path apply(String file) {
                        return fileSupplier.resolve(file);
                    }
                });
            }
        }).filter((Predicate)new Predicate<Path>(){

            public boolean apply(Path file) {
                return Files.exists(file, new LinkOption[0]);
            }
        });
    }

    private Iterable<Path> directories() {
        String packageDirectory = this.resolveDirectory();
        return FluentIterable.from((Object[])new String[]{"${" + packageDirectory + ".config.dir}/." + packageDirectory, "${" + packageDirectory + ".config.dir}/" + packageDirectory, "${user.home}/." + packageDirectory, "${user.home}/" + packageDirectory, "${conf.dir}/." + packageDirectory, "${conf.dir}/" + packageDirectory, "/etc/" + packageDirectory}).transform((Function)new Function<String, String>(){

            public String apply(String s) {
                return ConfigurationFileProvider.this.environment.resolvePlaceholders(s);
            }
        }).transform((Function)new Function<String, Path>(){

            public Path apply(String s) {
                return Paths.get(s, new String[0]);
            }
        });
    }

    @Generated
    public ConfigurationFileProvider(Environment environment) {
        this.environment = environment;
    }
}

