/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.properties;

import com.cumulocity.microservice.properties.ConfigurationFileProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.DefaultPropertySourceFactory;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.ResourcePropertySource;

@Order(value=4)
public class PropertiesRunListener
implements SpringApplicationRunListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertiesRunListener.class);
    public static final int ORDER = 4;
    private final List<String> propertySourceNames = new ArrayList<String>();

    public PropertiesRunListener(SpringApplication application, String[] args) {
    }

    public void starting(ConfigurableBootstrapContext bootstrapContext) {
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        ConfigurationFileProvider provider = new ConfigurationFileProvider((Environment)environment);
        Iterable<Path> locations = provider.find(".properties", "-server.properties", "-agent-server.properties", "-default.properties");
        for (Path location : locations) {
            log.info("Configuration file loaded {}", (Object)location);
        }
        this.processPropertySource(environment, locations);
    }

    public void environmentPrepared(ConfigurableBootstrapContext bootstrapContext, ConfigurableEnvironment environment) {
        this.environmentPrepared(environment);
    }

    public void contextPrepared(ConfigurableApplicationContext configurableApplicationContext) {
    }

    public void contextLoaded(ConfigurableApplicationContext configurableApplicationContext) {
    }

    public void started(ConfigurableApplicationContext context, Duration timeTaken) {
    }

    public void ready(ConfigurableApplicationContext context, Duration timeTaken) {
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }

    private void processPropertySource(ConfigurableEnvironment environment, Iterable<Path> locations) {
        DefaultPropertySourceFactory factory = new DefaultPropertySourceFactory();
        for (Path location : locations) {
            try {
                PathResource resource = new PathResource(location);
                PropertySource propertySource = factory.createPropertySource(null, new EncodedResource((Resource)resource, "UTF8"));
                String name = propertySource.getName();
                MutablePropertySources propertySources = environment.getPropertySources();
                if (propertySources.contains(name) && this.propertySourceNames.contains(name)) {
                    PropertySource newSource;
                    PropertySource existing = propertySources.get(name);
                    Object object = newSource = propertySource instanceof ResourcePropertySource ? ((ResourcePropertySource)propertySource).withResourceName() : propertySource;
                    if (existing instanceof CompositePropertySource) {
                        ((CompositePropertySource)existing).addFirstPropertySource(newSource);
                    } else {
                        if (existing instanceof ResourcePropertySource) {
                            existing = ((ResourcePropertySource)existing).withResourceName();
                        }
                        CompositePropertySource composite = new CompositePropertySource(name);
                        composite.addPropertySource(newSource);
                        composite.addPropertySource(existing);
                        propertySources.replace(name, (PropertySource)composite);
                    }
                } else if (this.propertySourceNames.isEmpty()) {
                    propertySources.addLast(propertySource);
                } else {
                    String firstProcessed = this.propertySourceNames.get(this.propertySourceNames.size() - 1);
                    propertySources.addBefore(firstProcessed, propertySource);
                }
                this.propertySourceNames.add(name);
            }
            catch (FileNotFoundException resource) {
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

