/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.microservice.api;

import com.cumulocity.microservice.api.CumulocityClientProperties;
import com.cumulocity.microservice.context.ContextService;
import com.cumulocity.microservice.context.credentials.Credentials;
import com.cumulocity.microservice.context.credentials.MicroserviceCredentials;
import com.cumulocity.microservice.context.credentials.UserCredentials;
import com.cumulocity.microservice.context.inject.TenantScope;
import com.cumulocity.microservice.context.inject.UserScope;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.model.authentication.CumulocityCredentialsFactory;
import com.cumulocity.sdk.client.HttpClientConfig;
import com.cumulocity.sdk.client.Platform;
import com.cumulocity.sdk.client.PlatformBuilder;
import com.cumulocity.sdk.client.PlatformImpl;
import com.cumulocity.sdk.client.ResponseMapper;
import com.cumulocity.sdk.client.RestConnector;
import com.cumulocity.sdk.client.RestOperations;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.alarm.AlarmApi;
import com.cumulocity.sdk.client.audit.AuditRecordApi;
import com.cumulocity.sdk.client.base.Supplier;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.devicecontrol.DeviceCredentialsApi;
import com.cumulocity.sdk.client.event.EventApi;
import com.cumulocity.sdk.client.event.EventBinaryApi;
import com.cumulocity.sdk.client.identity.IdentityApi;
import com.cumulocity.sdk.client.inventory.BinariesApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.cumulocity.sdk.client.measurement.MeasurementApi;
import com.cumulocity.sdk.client.messaging.notifications.NotificationSubscriptionApi;
import com.cumulocity.sdk.client.messaging.notifications.TokenApi;
import com.cumulocity.sdk.client.notification2.Notifications2Api;
import com.cumulocity.sdk.client.option.SystemOptionApi;
import com.cumulocity.sdk.client.option.TenantOptionApi;
import com.cumulocity.sdk.client.user.UserApi;
import jakarta.annotation.PreDestroy;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={CumulocityClientProperties.class})
public class CumulocityClientFeature {
    @Value(value="${platform.url:http://localhost:8181}")
    private String baseUrlFallback;
    @Autowired
    private CumulocityClientProperties clientProperties;
    @Autowired(required=false)
    private ResponseMapper responseMapper;

    private PlatformImpl platformFor(Supplier<Credentials> credentialsSupplier) {
        Credentials login = (Credentials)credentialsSupplier.get();
        CumulocityCredentials credentials = new CumulocityCredentialsFactory().withTenant(login.getTenant()).withUsername(login.getUsername()).withPassword(login.getPassword()).withOAuthAccessToken(login.getOAuthAccessToken()).withXsrfToken(login.getXsrfToken()).withApplicationKey(login.getAppKey()).getCredentials();
        PlatformImpl platform = (PlatformImpl)PlatformBuilder.platform().withBaseUrl(this.getBaseUrl()).withProxyHost(this.clientProperties.getProxy()).withProxyPort(Integer.valueOf(this.clientProperties.getProxyPort())).withCredentials(credentials).withTfaToken(login.getTfaToken()).withResponseMapper(this.responseMapper).withForceInitialHost(true).withNotifications2(this.clientProperties.getNotifications2()).build();
        this.setHttpClientConfig(platform);
        return platform;
    }

    private String getBaseUrl() {
        return Optional.ofNullable(this.clientProperties.getBaseURL()).orElse(this.baseUrlFallback);
    }

    private void setHttpClientConfig(PlatformImpl platform) {
        HttpClientConfig httpClientConfig = this.clientProperties.getHttpclient();
        if (this.clientProperties.getHttpReadTimeout() != null) {
            httpClientConfig.setHttpReadTimeout(this.clientProperties.getHttpReadTimeout().intValue());
        }
        platform.setHttpClientConfig(httpClientConfig);
    }

    @UserScope
    @Configuration(value="userPlatform")
    class UserPlatformConfig
    implements Platform {
        private PlatformImpl delegate;

        UserPlatformConfig() {
        }

        @Autowired
        void setContextService(ContextService<UserCredentials> userContextService) {
            this.delegate = CumulocityClientFeature.this.platformFor((Supplier<Credentials>)((Supplier)() -> userContextService.getContext()));
        }

        PlatformImpl getDelegate() {
            return this.delegate;
        }

        @UserScope
        @Bean(name={"userCredentials"})
        public CumulocityCredentials credentials() {
            return this.delegate.getCumulocityCredentials();
        }

        @UserScope
        @Bean(destroyMethod="close")
        public RestConnector userRestConnector() {
            return this.delegate.createRestConnector();
        }

        public RestOperations rest() {
            return this.delegate.rest();
        }

        @UserScope
        @Bean(name={"userInventoryApi"})
        public InventoryApi getInventoryApi() throws SDKException {
            return this.delegate.getInventoryApi();
        }

        @UserScope
        @Bean(name={"userIdentityApi"})
        public IdentityApi getIdentityApi() throws SDKException {
            return this.delegate.getIdentityApi();
        }

        @UserScope
        @Bean(name={"userMeasurementApi"})
        public MeasurementApi getMeasurementApi() throws SDKException {
            return this.delegate.getMeasurementApi();
        }

        @UserScope
        @Bean(name={"userDeviceControlApi"})
        public DeviceControlApi getDeviceControlApi() throws SDKException {
            return this.delegate.getDeviceControlApi();
        }

        @UserScope
        @Bean(name={"userAlarmApi"})
        public AlarmApi getAlarmApi() throws SDKException {
            return this.delegate.getAlarmApi();
        }

        @UserScope
        @Bean(name={"userEventApi"})
        public EventApi getEventApi() throws SDKException {
            return this.delegate.getEventApi();
        }

        @UserScope
        @Bean(name={"userEventBinaryApi"})
        public EventBinaryApi getEventBinaryApi() throws SDKException {
            return this.delegate.getEventBinaryApi();
        }

        @UserScope
        @Bean(name={"userAuditRecordApi"})
        public AuditRecordApi getAuditRecordApi() throws SDKException {
            return this.delegate.getAuditRecordApi();
        }

        @UserScope
        @Bean(name={"userDeviceCredentialsApi"})
        public DeviceCredentialsApi getDeviceCredentialsApi() throws SDKException {
            return this.delegate.getDeviceCredentialsApi();
        }

        @UserScope
        @Bean(name={"userBinariesApi"})
        public BinariesApi getBinariesApi() throws SDKException {
            return this.delegate.getBinariesApi();
        }

        @UserScope
        @Bean(name={"userUserApi"})
        public UserApi getUserApi() throws SDKException {
            return this.delegate.getUserApi();
        }

        @UserScope
        @Bean(name={"userTenantOptionApi"})
        public TenantOptionApi getTenantOptionApi() throws SDKException {
            return this.delegate.getTenantOptionApi();
        }

        @UserScope
        @Bean(name={"userSystemOptionApi"})
        public SystemOptionApi getSystemOptionApi() throws SDKException {
            return this.delegate.getSystemOptionApi();
        }

        @UserScope
        @Bean(name={"userTokenApi"})
        public TokenApi getTokenApi() throws SDKException {
            return this.delegate.getTokenApi();
        }

        @UserScope
        @Bean(name={"userNotificationSubscriptionApi"})
        public NotificationSubscriptionApi getNotificationSubscriptionApi() throws SDKException {
            return this.delegate.getNotificationSubscriptionApi();
        }

        @UserScope
        @Bean(name={"userNotifications2Api"})
        public Notifications2Api getNotifications2Api() throws SDKException {
            return this.delegate.getNotifications2Api();
        }

        @PreDestroy
        public void close() {
            this.delegate.close();
        }
    }

    @Primary
    @TenantScope
    @Configuration(value="tenantPlatform")
    class TenantPlatformConfig
    implements Platform {
        private PlatformImpl delegate;

        TenantPlatformConfig() {
        }

        @Autowired
        void setContextService(ContextService<MicroserviceCredentials> microserviceContextService) {
            this.delegate = CumulocityClientFeature.this.platformFor((Supplier<Credentials>)((Supplier)() -> microserviceContextService.getContext()));
        }

        PlatformImpl getDelegate() {
            return this.delegate;
        }

        @Primary
        @TenantScope
        @Bean(name={"tenantCredentials"})
        public CumulocityCredentials credentials() {
            return this.delegate.getCumulocityCredentials();
        }

        @Primary
        @TenantScope
        @Bean(destroyMethod="close")
        public RestConnector tenantRestConnector() {
            return this.delegate.createRestConnector();
        }

        public RestOperations rest() {
            return this.delegate.rest();
        }

        @Primary
        @TenantScope
        @Bean(name={"inventoryApi", "tenantInventoryApi"})
        public InventoryApi getInventoryApi() throws SDKException {
            return this.delegate.getInventoryApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"identityApi", "tenantIdentityApi"})
        public IdentityApi getIdentityApi() throws SDKException {
            return this.delegate.getIdentityApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"measurementApi", "tenantMeasurementApi"})
        public MeasurementApi getMeasurementApi() throws SDKException {
            return this.delegate.getMeasurementApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"deviceControlApi", "tenantDeviceControlApi"})
        public DeviceControlApi getDeviceControlApi() throws SDKException {
            return this.delegate.getDeviceControlApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"alarmApi", "tenantAlarmApi"})
        public AlarmApi getAlarmApi() throws SDKException {
            return this.delegate.getAlarmApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"eventApi", "tenantEventApi"})
        public EventApi getEventApi() throws SDKException {
            return this.delegate.getEventApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"eventBinaryApi", "tenantEventBinaryApi"})
        public EventBinaryApi getEventBinaryApi() throws SDKException {
            return this.delegate.getEventBinaryApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"auditRecordApi", "tenantAuditRecordApi"})
        public AuditRecordApi getAuditRecordApi() throws SDKException {
            return this.delegate.getAuditRecordApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"deviceCredentialsApi", "tenantDeviceCredentialsApi"})
        public DeviceCredentialsApi getDeviceCredentialsApi() throws SDKException {
            return this.delegate.getDeviceCredentialsApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"binariesApi", "tenantBinariesApi"})
        public BinariesApi getBinariesApi() throws SDKException {
            return this.delegate.getBinariesApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"userApi", "tenantUserApi"})
        public UserApi getUserApi() throws SDKException {
            return this.delegate.getUserApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"tenantOptionApi", "tenantTenantOptionApi"})
        public TenantOptionApi getTenantOptionApi() throws SDKException {
            return this.delegate.getTenantOptionApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"systemOptionApi", "tenantSystemOptionApi"})
        public SystemOptionApi getSystemOptionApi() throws SDKException {
            return this.delegate.getSystemOptionApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"tokenApi", "tenantTokenApi"})
        public TokenApi getTokenApi() throws SDKException {
            return this.delegate.getTokenApi();
        }

        @Primary
        @TenantScope
        @Bean(name={"notificationSubscriptionApi", "tenantNotificationSubscriptionApi"})
        public NotificationSubscriptionApi getNotificationSubscriptionApi() throws SDKException {
            return this.delegate.getNotificationSubscriptionApi();
        }

        @TenantScope
        @Bean(name={"notifications2Api", "tenantNotifications2Api"})
        public Notifications2Api getNotifications2Api() throws SDKException {
            return this.delegate.getNotifications2Api();
        }

        @PreDestroy
        public void close() {
            this.delegate.close();
        }
    }
}

