/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model;

import com.cumulocity.model.util.CumulocityStorageUnit;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSize
implements Comparable<DataSize> {
    public static final String MEMORY_ZERO_MBYTES = "0M";
    private static final String DEFAULT_UNIT = "B";
    private final BigDecimal quantity;
    private final String unit;
    public static final String DATA_SIZE_VALUE_PATTERN = "^((\\d+)\\s*([BKMGTEP][i]?)?)$";
    private static final Pattern DATA_SIZE_PATTERN = Pattern.compile("^((\\d+)\\s*([BKMGTEP][i]?)?)$");

    @ConstructorProperties(value={"quantity", "unit"})
    private DataSize(BigDecimal quantity, String unit) {
        this.quantity = quantity;
        this.unit = unit;
    }

    public static Optional<DataSize> tryParse(String data) {
        if (Strings.isNullOrEmpty((String)data) || !DATA_SIZE_PATTERN.matcher(data).matches()) {
            return Optional.absent();
        }
        return Optional.of((Object)DataSize.parse(data));
    }

    public static DataSize parse(String data) {
        Preconditions.checkNotNull((Object)data, (Object)"Data size string can't be null");
        Matcher matcher = DATA_SIZE_PATTERN.matcher(data);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)("Data size needs to match " + DATA_SIZE_PATTERN.pattern()));
        String quantity = matcher.group(2);
        String unit = matcher.group(3);
        return new DataSize(BigDecimal.valueOf(Double.parseDouble(quantity)), (String)MoreObjects.firstNonNull((Object)unit, (Object)DEFAULT_UNIT));
    }

    public static DataSize of(double quantity, String unit) {
        return DataSize.of(BigDecimal.valueOf(quantity), unit);
    }

    public static DataSize of(BigDecimal quantity, String unit) {
        return new DataSize(quantity, unit);
    }

    public static DataSize ofBytes(long value) {
        return DataSize.of(value, DEFAULT_UNIT);
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        String other$unit;
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSize)) {
            return false;
        }
        DataSize other = (DataSize)o;
        if (this.getQuantity().compareTo(other.getQuantity()) != 0) {
            return false;
        }
        String this$unit = this.getUnit();
        return Objects.equals(this$unit, other$unit = other.getUnit());
    }

    @Override
    public int compareTo(DataSize o) {
        if (o.quantity == this.quantity && o.unit == this.unit) {
            return 0;
        }
        long myBytes = CumulocityStorageUnit.getBytes(this.quantity.longValue(), this.unit);
        long oBytes = CumulocityStorageUnit.getBytes(o.quantity.longValue(), o.unit);
        return Long.compare(myBytes, oBytes);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $quantity = this.getQuantity().hashCode();
        result = result * 59 + (int)($quantity >>> 32 ^ $quantity);
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        return result;
    }

    public String toString() {
        return this.defaultFormat().format(this.getQuantity().setScale(2, 1)) + this.getUnit();
    }

    private DecimalFormat defaultFormat() {
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(2);
        format.setMinimumFractionDigits(0);
        format.setGroupingUsed(false);
        return format;
    }
}

