/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging;

import com.google.common.base.Strings;

public class DockerImage {
    private final String registry;
    private final String name;
    private final String tag;

    public DockerImage(String registry, String name, String tag) {
        this.registry = registry;
        this.name = name;
        this.tag = tag;
    }

    public DockerImage withName(String name) {
        return new DockerImage(this.registry, name, this.tag);
    }

    public DockerImage withRegistry(String registry) {
        return new DockerImage(registry, this.name, this.tag);
    }

    public DockerImage withTag(String tag) {
        return new DockerImage(this.registry, this.name, tag);
    }

    public static DockerImage of(String registry) {
        return new DockerImage(registry, null, null);
    }

    public static DockerImage ofName(String name) {
        return new DockerImage(null, name, null);
    }

    public String toString() {
        StringBuilder image = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)this.registry)) {
            image.append(this.registry).append("/");
        }
        image.append(this.name);
        if (!Strings.isNullOrEmpty((String)this.tag)) {
            image.append(":").append(this.tag);
        }
        return image.toString();
    }
}

