/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.uploadMojo.platform.client.impl;

import com.cumulocity.agent.packaging.uploadMojo.configuration.CredentialsConfiguration;
import com.cumulocity.agent.packaging.uploadMojo.platform.client.Executor;
import com.cumulocity.agent.packaging.uploadMojo.platform.client.Request;
import com.cumulocity.agent.packaging.uploadMojo.platform.client.impl.ProgressFileBody;
import com.cumulocity.agent.packaging.uploadMojo.platform.client.impl.UrlUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;

public class ApacheHttpClientExecutor
implements Executor {
    private final ObjectMapper mapper = new ObjectMapper(){
        {
            this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        }
    };
    private final CloseableHttpClient client;
    private final String url;
    private final Log log;

    public ApacheHttpClientExecutor(final CredentialsConfiguration credentials, Log log, MavenSession mavenSession) {
        this.log = log;
        this.url = UrlUtils.ensureHttpSchema(credentials.getUrl());
        this.client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider(){

            public Credentials getCredentials(AuthScope authscope) {
                return new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
            }
        }).setProxy(this.getProxyHost(mavenSession)).build();
    }

    private HttpHost getProxyHost(MavenSession mavenSession) {
        try {
            List list = mavenSession.getSettings().getProxies();
            for (Proxy proxy : list) {
                if (!proxy.isActive()) continue;
                String pS = proxy.getProtocol() + "://" + proxy.getHost() + ":" + proxy.getPort();
                this.log.info((CharSequence)("Found Proxy settings and passing to Apache Client: " + pS));
                return new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public <T> T execute(Request<T> request) {
        try {
            HttpUriRequest httpRequest = this.build(request);
            CloseableHttpResponse response = this.client.execute(httpRequest);
            if (response.getStatusLine().getStatusCode() >= 400) {
                Map result = this.result(Map.class, response);
                Object message = null;
                if (result != null) {
                    message = result.get("message");
                }
                throw new RuntimeException(String.valueOf(response.getStatusLine()) + " - " + message);
            }
            return this.result(request.getResult(), response);
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private <T> T result(Class<T> result, CloseableHttpResponse response) throws IOException {
        if (response.getEntity() != null) {
            String value = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.forName("UTF-8"));
            if (String.class.equals(result)) {
                return (T)value;
            }
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return (T)this.mapper.readValue(value, result);
            }
        }
        return null;
    }

    private HttpUriRequest build(Request request) throws IOException {
        if (Request.Method.GET.equals((Object)request.getMethod())) {
            HttpGet result = new HttpGet(UrlUtils.concat(this.getUrl(), request.getPath()));
            result.setHeader("Accept", "application/json");
            return result;
        }
        if (Request.Method.DELETE.equals((Object)request.getMethod())) {
            return new HttpDelete(UrlUtils.concat(this.getUrl(), request.getPath()));
        }
        if (Request.Method.POST.equals((Object)request.getMethod())) {
            HttpPost result = new HttpPost(UrlUtils.concat(this.getUrl(), request.getPath()));
            result.setHeader("Accept", "application/json");
            File multipartBody = request.getMultipartBody();
            String multipartName = request.getMultipartName();
            if (multipartBody != null) {
                HttpEntity entity = MultipartEntityBuilder.create().addPart("file", (ContentBody)new ProgressFileBody(multipartBody, this.getContentType(multipartBody), multipartName)).build();
                result.setEntity(entity);
            }
            if (request.getJsonBody() != null) {
                String string = this.mapper.writeValueAsString(request.getJsonBody());
                result.setHeader("Content-Type", "application/json");
                StringEntity entity = new StringEntity(string);
                result.setEntity((HttpEntity)entity);
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported method " + request.getMethod());
    }

    private ContentType getContentType(File file) {
        if (file.getName().endsWith("zip")) {
            return ContentType.create((String)"application/zip");
        }
        return ContentType.DEFAULT_BINARY;
    }

    @Generated
    private ObjectMapper getMapper() {
        return this.mapper;
    }

    @Generated
    private CloseableHttpClient getClient() {
        return this.client;
    }

    @Generated
    private String getUrl() {
        return this.url;
    }

    @Generated
    private Log getLog() {
        return this.log;
    }
}

