/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.uploadMojo.configuration;

import com.cumulocity.agent.packaging.uploadMojo.configuration.CredentialsConfiguration;
import com.cumulocity.agent.packaging.uploadMojo.configuration.common.ServerUtils;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class CredentialsConfigurationSupplier {
    private final String serviceId;
    private final Settings settings;
    private final CredentialsConfiguration source;
    private final AtomicReference<Object> object = new AtomicReference();

    private Optional<CredentialsConfiguration> get() {
        CredentialsConfiguration result;
        CredentialsConfiguration.CredentialsConfigurationBuilder builder = this.source.toBuilder();
        if (StringUtils.isBlank((CharSequence)this.source.getPassword())) {
            builder.password(this.getSettingsPassword().orElse(null));
        }
        if (StringUtils.isBlank((CharSequence)this.source.getUsername())) {
            builder.username(this.getSettingsUsername().orElse(null));
        }
        if (StringUtils.isBlank((CharSequence)this.source.getUrl())) {
            builder.url(this.getSettingsUrl().orElse(null));
        }
        if ((result = builder.build()).isPresent()) {
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private Optional<String> getSettingsUsername() {
        return this.getServer().map(ServerUtils.getServerUsername()).filter((Predicate<String>)ServerUtils.isNotBlank()).findFirst();
    }

    private Optional<String> getSettingsPassword() {
        return this.getServer().map(ServerUtils.getServerPassword()).filter((Predicate<String>)ServerUtils.isNotBlank()).findFirst();
    }

    private Optional<String> getSettingsUrl() {
        return this.getServer().map(ServerUtils.getConfigurationString("url")).filter((Predicate<String>)ServerUtils.isNotBlank()).findFirst();
    }

    private Stream<Server> getServer() {
        Server server = this.settings.getServer(this.serviceId);
        if (server == null) {
            return Stream.of(new Server[0]);
        }
        return Stream.of(server);
    }

    @Generated
    public CredentialsConfigurationSupplier(String serviceId, Settings settings, CredentialsConfiguration source) {
        this.serviceId = serviceId;
        this.settings = settings;
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Optional<CredentialsConfiguration> getObject() {
        Object $value = this.object.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.object;
            synchronized (atomicReference) {
                $value = this.object.get();
                if ($value == null) {
                    Optional<CredentialsConfiguration> actualValue = this.get();
                    $value = actualValue == null ? this.object : actualValue;
                    this.object.set($value);
                }
            }
        }
        return (Optional)($value == this.object ? null : $value);
    }
}

