/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging;

import com.cumulocity.agent.packaging.BaseMicroserviceMojo;
import com.cumulocity.agent.packaging.DockerBuildInfo;
import com.cumulocity.agent.packaging.DockerBuildSpec;
import com.cumulocity.agent.packaging.RpmDsl;
import com.cumulocity.agent.packaging.microservice.MicroserviceDockerClient;
import com.cumulocity.model.DataSize;
import com.cumulocity.model.Resources;
import com.cumulocity.model.application.MicroserviceManifest;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=false)
public class PackageMojo
extends BaseMicroserviceMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PackageMojo.class);
    public static final DataSize MEMORY_MINIMAL_LIMIT = DataSize.parse("178Mi");
    public static final String BUILD_SPEC_FRAGMENT = "buildSpec";
    public static final String DOCKER_BUILD_INFO_FRAGMENT = "dockerBuildInfo";
    public static final String MANIFEST_JSON_FILENAME = "cumulocity.json";
    public static final String DOCKER_IMAGE_TAR = "image.tar";
    @Component
    protected MicroserviceDockerClient dockerClient;
    @Parameter(defaultValue="${basedir}/src/main/configuration/cumulocity.json")
    protected File manifestFile;
    @Parameter(property="package.name", defaultValue="${project.artifactId}")
    protected String image;
    @Parameter(property="microservice.package.dockerBuildNetwork")
    private String dockerBuildNetwork;
    @Parameter(property="microservice.package.deleteImage", defaultValue="true")
    protected Boolean deleteImage = true;
    @Parameter(property="microservice.package.dockerBuildArchs")
    protected String targetBuildArchs;
    @Parameter(defaultValue="${mojoExecution}")
    protected MojoExecution mojoExecution;
    @Parameter(property="microservice.package.dockerBuildTimeout", defaultValue="360")
    public int dockerBuildTimeout = 360;
    @Parameter(property="microservice.package.dockerSaveWaitTimeOut", defaultValue="360")
    public int dockerImageInRegistryMaxWaitTime = 360;
    protected ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping agent packaging");
            return;
        }
        if (!this.rpmSkip) {
            this.getLog().info((CharSequence)("rpm package " + this.project.getArtifactId()));
            this.rpmPackage();
        }
        if (!this.containerSkip) {
            Iterable<String> buildTargetArchitectures = this.getTargetBuildArchitectures();
            log.info("Starting docker microservice build for the following target architectures: {}", buildTargetArchitectures);
            for (String arch : buildTargetArchitectures) {
                this.getLog().info((CharSequence)("docker container " + this.project.getArtifactId() + " in network '" + (this.dockerBuildNetwork != null ? this.dockerBuildNetwork : "<default>") + "'"));
                this.dockerContainer(arch);
                if (this.skipMicroservicePackage) continue;
                this.getLog().info((CharSequence)("microservice zip container " + this.project.getArtifactId()));
                this.microserviceZip(arch);
            }
        }
    }

    private void rpmPackage() throws MojoExecutionException {
        try {
            this.copyArtifact(new File(this.rpmBaseBuildDir, "bin"));
            this.copyFromPluginSubdirectory("rpm", this.rpmTmpDir);
            this.copyFromProjectSubdirectoryAndReplacePlaceholders(this.resource(this.rpmTmpDir.getAbsolutePath()), this.rpmBaseBuildDir, false);
            this.copyFromProjectSubdirectoryAndReplacePlaceholders(this.resource(this.srcConfigurationDir.getAbsolutePath()), new File(this.rpmBaseBuildDir, "etc"), true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MojoExecutor.executeMojo((Plugin)RpmDsl.rpm(), (String)MojoExecutor.goal((String)"attached-rpm"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"name", (String)this.name), MojoExecutor.element((String)"group", (String)"C8Y/Agent"), MojoExecutor.element((String)"distribution", (String)("Cumulocity GmbH " + RpmDsl.currentYear())), MojoExecutor.element((String)"packager", (String)"Cumulocity GmbH"), MojoExecutor.element((String)"requires", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"require"), (String)(this.requireJava() + " >= " + this.javaRuntime))}), MojoExecutor.element((String)"repackJars", (String)String.valueOf(false)), RpmDsl.mappings(RpmDsl.mapping(RpmDsl.directory("/usr/lib/" + this.directory), RpmDsl.sources(RpmDsl.source(RpmDsl.location(new File(this.rpmBaseBuildDir, "bin").getAbsolutePath())))), RpmDsl.mapping(RpmDsl.directory("/usr/lib/systemd/system"), RpmDsl.directoryIncluded(false), RpmDsl.configuration(true), RpmDsl.sources(RpmDsl.source(RpmDsl.location(new File(this.rpmBaseBuildDir, "systemd").getAbsolutePath()), RpmDsl.includes(RpmDsl.include(String.format("%s.service", this.name)))))), RpmDsl.mapping(RpmDsl.directory("/etc/init.d"), RpmDsl.directoryIncluded(false), RpmDsl.configuration(true), RpmDsl.sources(RpmDsl.source(RpmDsl.location(new File(this.rpmBaseBuildDir, "init.d").getAbsolutePath()), RpmDsl.includes(RpmDsl.include(this.name))))), RpmDsl.mapping(RpmDsl.directory("/etc/" + this.directory), RpmDsl.directoryIncluded(false), RpmDsl.configuration("noreplace"), RpmDsl.sources(RpmDsl.source(RpmDsl.location(new File(this.rpmBaseBuildDir, "etc").getAbsolutePath())))))}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private void dockerContainer(String targetArchitecture) {
        File dockerWorkResources = new File(this.dockerWorkDir, "resources");
        try {
            this.cleanDirectory(dockerWorkResources);
            this.copyArtifact(dockerWorkResources);
            File buildTmp = new File(this.build, "tmp");
            this.copyFromPluginSubdirectory("docker", buildTmp);
            this.copyFromProjectSubdirectoryAndReplacePlaceholders(this.resource(buildTmp.getAbsolutePath()), this.dockerWorkDir, false);
            this.cleanDirectory(buildTmp);
            this.copyFromProjectSubdirectoryAndReplacePlaceholders(this.resource(this.srcConfigurationDir.getAbsolutePath()), new File(this.dockerWorkDir, "etc"), true);
            this.copyFromProjectSubdirectoryAndReplacePlaceholders(this.resource(this.srcDockerDir.getAbsolutePath()), this.dockerWorkDir, true);
            this.buildDockerImage(targetArchitecture);
            this.cleanDirectory(new File(this.build, "docker"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Iterable<String> getTargetBuildArchitectures() {
        File file;
        if (Objects.nonNull(this.targetBuildArchs)) {
            log.info("Using custom target build architectures from maven configuration (overriding microservice manifest): {}", (Object)this.targetBuildArchs);
            return Arrays.asList(this.targetBuildArchs.split(","));
        }
        try {
            file = this.filterResourceFile(this.manifestFile);
        }
        catch (IOException e) {
            log.error("Can't read manifest file {}", (Object)this.manifestFile);
            throw e;
        }
        catch (MavenFilteringException e) {
            log.error("Maven filtering exception {}", (Object)e.getMessage());
            throw e;
        }
        Map jsonManifest = (Map)this.mapper.readValue(file, Map.class);
        if (jsonManifest.containsKey(BUILD_SPEC_FRAGMENT)) {
            DockerBuildSpec buildSpec = (DockerBuildSpec)this.mapper.convertValue(jsonManifest.get(BUILD_SPEC_FRAGMENT), DockerBuildSpec.class);
            log.info("Using build target images from build spec: {}", buildSpec.getTargetBuildArchitectures());
            return buildSpec.getTargetBuildArchitectures();
        }
        log.info("Manifest contains no buildspec and target architectures. Using defaults");
        return DockerBuildSpec.defaultBuildSpec().getTargetBuildArchitectures();
    }

    private void buildDockerImage(String targetBuildArch) {
        log.info("Building microservice image for target architecture {}", (Object)targetBuildArch);
        Map<String, String> buildArgs = this.configureProxyBuildArguments();
        Set<String> tags = this.getDockerImageNameExpandedWithTags();
        if (!targetBuildArch.equals("linux/amd64")) {
            log.warn("Your target build architecture {} does not match the default target {}", (Object)targetBuildArch, (Object)"linux/amd64");
            log.warn("Currently, Cumulocity only supports hosting microservices build for {}", (Object)"linux/amd64");
            log.warn("Your image might be incompatible with cloud hosting!");
        }
        this.dockerClient.buildDockerImage(this.dockerWorkDir.getAbsolutePath(), tags, buildArgs, targetBuildArch, this.dockerBuildNetwork, this.dockerBuildTimeout, new PullCredentials().asAuthConfigurations());
    }

    private DockerBuildInfo getDockerBuildInfo(String targetBuildArch) {
        return DockerBuildInfo.defaultInfo().withImageArch(targetBuildArch).withCurrentBuildDate().withBuilderInfo(this.mojoExecution.getPlugin().getId()).withHostArchitecture().withHostOS();
    }

    private Set<String> getDockerImageNameExpandedWithTags() {
        String imageVersionTag = this.image + ":" + this.project.getVersion();
        String imageLatestTag = this.image + ":latest";
        return Sets.newHashSet((Object[])new String[]{imageLatestTag, imageVersionTag});
    }

    private Map<String, String> configureProxyBuildArguments() {
        String httpProxy = null;
        String httpsProxy = null;
        for (Proxy proxy : this.mavenSession.getSettings().getProxies()) {
            if (!proxy.isActive()) continue;
            String pS = proxy.getProtocol() + "://" + proxy.getHost() + ":" + proxy.getPort();
            this.getLog().info((CharSequence)("Found Proxy settings: " + pS));
            if (proxy.getProtocol().equals("http")) {
                httpProxy = pS;
            }
            if (!proxy.getProtocol().equals("https")) continue;
            httpsProxy = pS;
        }
        if (httpsProxy == null && httpProxy != null) {
            httpsProxy = httpProxy;
        }
        if (httpProxy == null && httpsProxy != null) {
            httpProxy = httpsProxy;
        }
        HashMap buildArgs = Maps.newHashMap();
        if (httpProxy != null) {
            buildArgs.put("HTTP_PROXY", httpProxy);
            buildArgs.put("http_proxy", httpProxy);
        }
        if (httpsProxy != null) {
            buildArgs.put("HTTPS_PROXY", httpsProxy);
            buildArgs.put("https_proxy", httpsProxy);
        }
        return buildArgs;
    }

    private void microserviceZip(String targetArchitecture) {
        try {
            String targetFilename = this.getTargetFilename(targetArchitecture);
            log.info("Saving microservice to {}", (Object)targetFilename);
            Files.createDirectories(this.build.toPath(), new FileAttribute[0]);
            String imageNameWithTagSave = String.format("%s:%s", this.image, this.project.getVersion());
            log.info("Checking if image {} is populated to registry", (Object)imageNameWithTagSave);
            this.dockerClient.waitForImageInRegistry(imageNameWithTagSave, this.dockerImageInRegistryMaxWaitTime);
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(new File(this.build, targetFilename)));){
                File file = this.filterResourceFile(this.manifestFile);
                this.validateManifest(file);
                this.addPlatformTaggedMicroserviceManifestToZipFile(targetArchitecture, this.filterResourceFile(this.manifestFile), zipOutputStream);
                this.saveDockerImageToZipOutputStream(imageNameWithTagSave, zipOutputStream);
            }
            if (this.deleteImage != null && this.deleteImage.booleanValue()) {
                Set<String> imageNameWithTags = this.getDockerImageNameExpandedWithTags();
                log.info("Deleting all images named {} and imageNameWithTags {}", (Object)this.image, imageNameWithTags);
                imageNameWithTags.forEach(imageNameWithTag -> this.dockerClient.deleteAll((String)imageNameWithTag, true));
            } else {
                this.getLog().info((CharSequence)"Skipping docker image cleanup");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void saveDockerImageToZipOutputStream(String imageNameWithTagSave, ZipOutputStream zipOutputStream) throws IOException, MavenExecutionException {
        ZipEntry ze = new ZipEntry(DOCKER_IMAGE_TAR);
        try {
            zipOutputStream.putNextEntry(ze);
            this.dockerClient.saveDockerImage(imageNameWithTagSave, zipOutputStream);
        }
        catch (Exception e) {
            log.error("Error saving Docker image to zip file: {}", (Object)e.getMessage());
            throw new MavenExecutionException("Image export to zip file failed", (Throwable)e);
        }
        finally {
            zipOutputStream.closeEntry();
        }
    }

    private void addPlatformTaggedMicroserviceManifestToZipFile(String targetArchitecture, File manifestFile, ZipOutputStream zipOutputStream) throws IOException {
        log.info("Tagging microservice manifest with image platform");
        ObjectNode manifest = (ObjectNode)this.mapper.readTree(manifestFile);
        DockerBuildInfo updated = this.getDockerBuildInfo(targetArchitecture);
        manifest.putPOJO(DOCKER_BUILD_INFO_FRAGMENT, (Object)updated);
        String jsonString = this.mapper.writeValueAsString((Object)manifest);
        ZipEntry ze = new ZipEntry(MANIFEST_JSON_FILENAME);
        zipOutputStream.putNextEntry(ze);
        BufferedWriter zipStringWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
        zipStringWriter.write(jsonString);
        zipStringWriter.flush();
        zipOutputStream.closeEntry();
    }

    private void validateManifest(File file) throws IOException, MavenExecutionException {
        log.info("Validating manifest");
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), Charsets.UTF_8);){
            MicroserviceManifest manifest = MicroserviceManifest.from(reader);
            ValidatorFactory factory = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory();
            Validator validator = factory.getValidator();
            Set constraintViolations = validator.validate((Object)manifest, new Class[0]);
            Set<ManifestConstraintViolation> violations = this.validateMemory(manifest);
            for (ConstraintViolation cviolation : constraintViolations) {
                violations.add(new ManifestConstraintViolation(cviolation.getPropertyPath().toString(), cviolation.getMessage()));
            }
            if (!violations.isEmpty()) {
                log.error("Manifest validation error!");
                violations.forEach(violation -> log.error("Validation error: {} {}", (Object)violation.getPath(), (Object)violation.getMessage()));
                throw new MavenExecutionException("Could not validate manifest", (Throwable)new IllegalArgumentException());
            }
        }
    }

    private Set<ManifestConstraintViolation> validateMemory(MicroserviceManifest manifest) {
        DataSize memoryLimit;
        Resources resources = manifest.getResources();
        if (resources != null && resources.getMemoryLimit().isPresent() && (memoryLimit = (DataSize)resources.getMemoryLimit().get()).compareTo(MEMORY_MINIMAL_LIMIT) < 0) {
            return Sets.newHashSet((Object[])new ManifestConstraintViolation[]{new ManifestConstraintViolation("resources.memory", "For java project memory needs to be at least " + MEMORY_MINIMAL_LIMIT)});
        }
        return Sets.newHashSet();
    }

    private File filterResourceFile(File source) throws IOException, MavenFilteringException {
        File filteredDir = new File(this.build, File.separator + "filtered-resources");
        MavenResourcesExecution execution = new MavenResourcesExecution((List)ImmutableList.of((Object)this.resource(source)), filteredDir, this.project, this.encoding, (List)ImmutableList.of(), (List)ImmutableList.of(), this.mavenSession);
        Files.createDirectories(filteredDir.toPath(), new FileAttribute[0]);
        execution.setOverwrite(true);
        this.mavenResourcesFiltering.filterResources(execution);
        return new File(filteredDir, File.separator + source.getName());
    }

    private Resource resource(File file) {
        Resource resource = new Resource();
        resource.setDirectory(file.getParent());
        resource.setFiltering(true);
        resource.setIncludes((List)ImmutableList.of((Object)file.getName()));
        resource.setExcludes((List)ImmutableList.of());
        return resource;
    }

    private String requireJava() {
        if ("8".equals(this.getJavaVersion())) {
            return "java";
        }
        return "java-" + this.getJavaVersion();
    }

    private class PullCredentials {
        private PullCredentials() {
        }

        public AuthConfigurations asAuthConfigurations() {
            AuthConfigurations authConfigurations = new AuthConfigurations();
            String registryAddress = this.getRegistryAddress();
            if (this.credentialsDefined()) {
                authConfigurations.addConfig(new AuthConfig().withRegistryAddress(registryAddress).withUsername(PackageMojo.this.registryUser).withPassword(PackageMojo.this.registryPass));
            } else if (this.isNonDefaultRegistry(registryAddress)) {
                PackageMojo.this.getLog().info((CharSequence)("Using unauthenticated access to " + registryAddress + ". To define credentials, configure both registryUser and registryPass."));
            }
            return authConfigurations;
        }

        private boolean credentialsDefined() {
            return StringUtils.isNotBlank((CharSequence)PackageMojo.this.registryUser) && StringUtils.isNotBlank((CharSequence)PackageMojo.this.registryPass);
        }

        private String getRegistryAddress() {
            if (StringUtils.isNotBlank((CharSequence)PackageMojo.this.registryUrl)) {
                return PackageMojo.this.registryUrl;
            }
            int registryUrlIndex = PackageMojo.this.baseImage.lastIndexOf("/");
            if (registryUrlIndex > 0) {
                return "https://" + PackageMojo.this.baseImage.substring(0, registryUrlIndex);
            }
            return "https://index.docker.io/v1/";
        }

        private boolean isNonDefaultRegistry(String registryAddress) {
            return !"https://index.docker.io/v1/".equals(registryAddress);
        }
    }

    private static final class ManifestConstraintViolation {
        private final String path;
        private final String message;

        @Generated
        public ManifestConstraintViolation(String path, String message) {
            this.path = path;
            this.message = message;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManifestConstraintViolation)) {
                return false;
            }
            ManifestConstraintViolation other = (ManifestConstraintViolation)o;
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PackageMojo.ManifestConstraintViolation(path=" + this.getPath() + ", message=" + this.getMessage() + ")";
        }
    }
}

