/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging;

import com.cumulocity.agent.packaging.Memory;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Resources;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

public abstract class BaseMicroserviceMojo
extends AbstractMojo {
    public static final String TARGET_FILENAME_PATTERN_NON_DEFAULT_ARCH = "%s-%s-%s.zip";
    public static final String TARGET_FILENAME_PATTERN_DEFAULT_ARCH = "%s-%s.zip";
    public static final String OTEL_JAVA_AGENT_DOWNLOAD_URL = "https://github.com/open-telemetry/opentelemetry-java-instrumentation/releases/download/v2.19.0/opentelemetry-javaagent.jar";
    @Parameter(property="agent-package.container.registry")
    protected String registry;
    @Component
    protected BuildPluginManager pluginManager;
    @Parameter(property="package.name", defaultValue="${project.artifactId}")
    protected String name;
    @Parameter(property="package.directory", defaultValue="${project.artifactId}")
    protected String directory;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${project.build.directory}")
    protected File build;
    @Parameter(defaultValue="${project.build.directory}/rpm-tmp")
    protected File rpmTmpDir;
    @Parameter(defaultValue="${project.build.directory}/docker-work")
    protected File dockerWorkDir;
    @Parameter(defaultValue="${project.build.directory}/rpm-base-build")
    protected File rpmBaseBuildDir;
    @Parameter(defaultValue="${basedir}/src/main/configuration")
    protected File srcConfigurationDir;
    @Parameter(defaultValue="${basedir}/src/main/docker")
    protected File srcDockerDir;
    @Parameter(defaultValue="false", property="skip.agent.package")
    protected boolean skip;
    @Parameter(defaultValue="true", property="skip.agent.package.rpm")
    protected boolean rpmSkip;
    @Parameter(defaultValue="false", property="skip.agent.package.container")
    protected boolean containerSkip;
    @Parameter(defaultValue="false", property="skip.microservice.package")
    protected boolean skipMicroservicePackage;
    @Parameter(defaultValue="${maven.compiler.release}, ${maven.compiler.target}, ${microservice.java.version}")
    protected String javaRuntime;
    @Component
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter(property="package.description", defaultValue="${project.description}")
    private String description;
    @Parameter(property="agent-package.jvmArgs")
    private List<String> jvmArgs;
    @Parameter(property="agent-package.otel-java-agent-download-url", defaultValue="https://github.com/open-telemetry/opentelemetry-java-instrumentation/releases/download/v2.19.0/opentelemetry-javaagent.jar")
    protected String otelJavaAgentDownloadUrl;
    @Parameter(property="agent-package.otel-java-agent-include", defaultValue="false")
    protected String otelJavaAgentInclude;
    @Parameter(property="agent-package.arguments")
    private List<String> arguments;
    @Parameter(property="project.build.sourceEncoding", defaultValue="UTF-8")
    protected String encoding;
    @Parameter(property="nonFilteredFileExtensions", defaultValue="jks,jar")
    private List<String> nonFilteredFileExtensions;
    @Parameter(property="agent-package.heap")
    private Memory heap;
    @Deprecated
    @Parameter(property="agent-package.perm")
    private Memory perm;
    @Parameter(property="agent-package.metaspace")
    private Memory metaspace;
    @Parameter(property="package.docker.baseImage", defaultValue="alpine:3")
    protected String baseImage;
    @Parameter(property="package.docker.registryUrl")
    protected String registryUrl;
    @Parameter(property="package.docker.registryUser")
    protected String registryUser;
    @Parameter(property="package.docker.registryPass")
    protected String registryPass;

    protected void copyFromProjectSubdirectoryAndReplacePlaceholders(Resource src, File destination, boolean override) throws Exception {
        MavenResourcesExecution execution = new MavenResourcesExecution((List)ImmutableList.of((Object)src), destination, this.project, this.encoding, (List)ImmutableList.of(), (List)ImmutableList.of(), this.mavenSession);
        this.getLog().info((CharSequence)("copy resources from " + src + " to" + destination));
        Files.createDirectories(destination.toPath(), new FileAttribute[0]);
        execution.setOverwrite(override);
        execution.setFilterFilenames(true);
        execution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
        execution.setDelimiters(Sets.newLinkedHashSet((Iterable)ImmutableSet.of((Object)"@*@")));
        execution.setSupportMultiLineFiltering(true);
        Properties props = new Properties();
        props.put("package.name", this.name);
        props.put("package.directory", this.directory);
        props.put("package.description", MoreObjects.firstNonNull((Object)this.description, (Object)(this.name + " Service")));
        props.put("package.jvm-heap", Joiner.on((char)' ').join(this.getJvmHeap()));
        props.put("package.jvm-meta", Joiner.on((char)' ').join(this.getJvmMeta()));
        props.put("package.jvm-mem", Joiner.on((char)' ').join(this.getJvmMem()));
        props.put("package.jvm-gc", Joiner.on((char)' ').join(this.getJvmGc()));
        props.put("package.arguments", Joiner.on((char)' ').join(this.arguments));
        props.put("package.java-version", this.getJavaVersion());
        props.put("package.otel-java-agent-download-url", this.otelJavaAgentDownloadUrl);
        props.put("package.otel-java-agent-include", this.otelJavaAgentInclude);
        props.put("package.required-java", this.javaRuntime);
        props.put("package.docker.baseImage", this.baseImage);
        execution.setAdditionalProperties(props);
        this.mavenResourcesFiltering.filterResources(execution);
    }

    private List<String> getJvmMem() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.getJvmHeap(), this.getJvmMeta()));
    }

    private List<String> getJvmHeap() {
        return this.heap.isEmpty() ? Collections.emptyList() : ImmutableList.of((Object)("-Xms" + this.heap.getMin()), (Object)("-Xmx" + this.heap.getMax()));
    }

    private List<String> getJvmMeta() {
        if (this.metaspace.isEmpty() && this.perm.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)("-XX:MetaspaceSize=" + (String)StringUtils.firstNonEmpty((CharSequence[])new String[]{this.metaspace.getMin(), this.perm.getMin()})), (Object)("-XX:MaxMetaspaceSize=" + (String)StringUtils.firstNonEmpty((CharSequence[])new String[]{this.metaspace.getMax(), this.perm.getMax()})));
    }

    private List<String> getJvmGc() {
        if (this.jvmArgs == null || this.jvmArgs.isEmpty()) {
            return ImmutableList.builder().add((Object[])new String[]{"-XX:+UseG1GC", "-XX:+UseStringDeduplication", "-XX:MinHeapFreeRatio=25", "-XX:MaxHeapFreeRatio=75"}).build();
        }
        return this.jvmArgs;
    }

    public void copyFromPluginSubdirectory(String src, File dest) throws IOException {
        this.copyTemplates(this.fromDirectory(src), dest);
    }

    private void copyTemplates(Predicate<? super ClassPath.ResourceInfo> filter, File dest) throws IOException {
        this.getLog().debug((CharSequence)"initialize templates");
        for (ClassPath.ResourceInfo resource : this.loadTemplates(filter)) {
            URL url = resource.url();
            this.getLog().debug((CharSequence)("template found " + resource.getResourceName()));
            String path = new File(resource.getResourceName()).getPath();
            File destination = new File(dest, path.substring(path.indexOf(File.separator)));
            com.google.common.io.Files.createParentDirs((File)destination);
            if (destination.exists() && Resources.asByteSource((URL)url).contentEquals(com.google.common.io.Files.asByteSource((File)destination))) continue;
            Resources.asByteSource((URL)url).copyTo(com.google.common.io.Files.asByteSink((File)destination, (FileWriteMode[])new FileWriteMode[0]));
        }
    }

    protected void copyArtifact(@NonNull File destination) throws IOException {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.getLog().debug((CharSequence)("copyArtifactTo " + this.project.getArtifact().getFile().toString()));
        File to = new File(destination, String.format("%s.jar", this.name));
        com.google.common.io.Files.createParentDirs((File)to);
        this.getLog().debug((CharSequence)String.format("copy artifact %s to %s ", this.project.getArtifact().getFile().getAbsolutePath(), to.getAbsolutePath()));
        if (!to.exists() || !com.google.common.io.Files.asByteSource((File)this.project.getArtifact().getFile()).contentEquals(com.google.common.io.Files.asByteSource((File)to))) {
            Files.copy(this.project.getArtifact().getFile().toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected void cleanDirectory(@NonNull File destination) throws IOException {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.getLog().debug((CharSequence)("cleanDirectory " + destination.getAbsolutePath()));
        if (destination.exists()) {
            FileUtils.cleanDirectory((File)destination);
        }
    }

    private ImmutableList<ClassPath.ResourceInfo> loadTemplates(Predicate<? super ClassPath.ResourceInfo> filter) throws IOException {
        return FluentIterable.from((Iterable)ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getResources()).filter(filter).toList();
    }

    protected Predicate<ClassPath.ResourceInfo> fromDirectory(final String directory) {
        return new Predicate<ClassPath.ResourceInfo>(){

            public boolean apply(ClassPath.ResourceInfo input) {
                return input.getResourceName().startsWith(directory);
            }
        };
    }

    public Resource resource(String resourceDirectory) {
        return this.resource(resourceDirectory, (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of());
    }

    public Resource resource(String resourceDirectory, List<String> includes, List<String> excludes) {
        Resource resource = new Resource();
        resource.setDirectory(resourceDirectory);
        resource.setFiltering(true);
        resource.setIncludes(includes);
        resource.setExcludes(excludes);
        return resource;
    }

    String getJavaVersion() {
        Pattern pattern = Pattern.compile("\\d+\\.?\\d*");
        Matcher matcher = pattern.matcher(this.javaRuntime);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Wrong format or missing java version. Missing at least one property from list: maven.compiler.release, maven.compiler.target, microservice.java.version in valid format (1.8, 11 etc.)");
        }
        this.javaRuntime = matcher.group();
        if (this.javaRuntime.startsWith("1.")) {
            return this.javaRuntime.substring(2);
        }
        return this.javaRuntime;
    }

    protected String getTargetFilename(String targetArchitecture) {
        if (targetArchitecture.equals("linux/amd64")) {
            return this.getDefaultTargetFilename();
        }
        return String.format(TARGET_FILENAME_PATTERN_NON_DEFAULT_ARCH, this.name, this.project.getVersion(), targetArchitecture).replaceAll("/", "-");
    }

    protected String getDefaultTargetFilename() {
        return String.format(TARGET_FILENAME_PATTERN_DEFAULT_ARCH, this.name, this.project.getVersion());
    }
}

