/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.uploadMojo.configuration;

import com.cumulocity.agent.packaging.uploadMojo.configuration.ApplicationConfiguration;
import com.cumulocity.agent.packaging.uploadMojo.configuration.common.ServerUtils;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class ApplicationConfigurationSupplier {
    private final String serviceId;
    private final Settings settings;
    private final ApplicationConfiguration application;
    private final String packageName;
    private final MavenProject project;
    private final AtomicReference<Object> object = new AtomicReference();

    private Optional<ApplicationConfiguration> get() {
        Boolean value;
        Optional<ApplicationConfiguration> settingsConfig = this.getSettingsConfig();
        ApplicationConfiguration.ApplicationConfigurationBuilder builder = this.application.toBuilder();
        builder.name(ApplicationConfiguration.shortenName(this.findApplicationName()));
        if (this.application.getDelete() == null && settingsConfig.isPresent()) {
            value = settingsConfig.get().getDelete();
            if (value != null) {
                builder.delete(value);
            } else {
                builder.delete(true);
            }
        } else {
            builder.delete(true);
        }
        if (this.application.getCreate() == null && settingsConfig.isPresent()) {
            value = settingsConfig.get().getCreate();
            if (value != null) {
                builder.create(value);
            } else {
                builder.create(true);
            }
        } else {
            builder.create(true);
        }
        if (this.application.getSubscriptions() == null && settingsConfig.isPresent()) {
            List<String> subscriptions = settingsConfig.get().getSubscriptions();
            if (subscriptions != null) {
                builder.subscriptions(subscriptions);
            } else {
                builder.subscriptions(Lists.newArrayList());
            }
        } else {
            builder.subscriptions(Lists.newArrayList());
        }
        return Optional.of(builder.build());
    }

    private String findApplicationName() {
        String value;
        if (StringUtils.isNotBlank((CharSequence)this.application.getName())) {
            return this.application.getName();
        }
        Optional<ApplicationConfiguration> settingsConfig = this.getSettingsConfig();
        if (settingsConfig.isPresent() && StringUtils.isNotBlank((CharSequence)(value = settingsConfig.get().getName()))) {
            return value;
        }
        return this.packageName;
    }

    private Optional<ApplicationConfiguration> getSettingsConfig() {
        return this.getServer().transformAndConcat(ServerUtils.getConfigurationList(ApplicationConfiguration.class, "applications")).filter(input -> {
            if (input.getGroupId() != null && !input.getGroupId().equals(this.project.getGroupId())) {
                return false;
            }
            return input.getArtifactId() == null || input.getArtifactId().equals(this.project.getArtifactId());
        }).first().toJavaUtil();
    }

    private FluentIterable<Server> getServer() {
        Server server = this.settings.getServer(this.serviceId);
        if (server == null) {
            return FluentIterable.of();
        }
        return FluentIterable.of((Object)server, (Object[])new Server[0]);
    }

    @Generated
    public ApplicationConfigurationSupplier(String serviceId, Settings settings, ApplicationConfiguration application, String packageName, MavenProject project) {
        this.serviceId = serviceId;
        this.settings = settings;
        this.application = application;
        this.packageName = packageName;
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Optional<ApplicationConfiguration> getObject() {
        Object $value = this.object.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.object;
            synchronized (atomicReference) {
                $value = this.object.get();
                if ($value == null) {
                    Optional<ApplicationConfiguration> actualValue = this.get();
                    $value = actualValue == null ? this.object : actualValue;
                    this.object.set($value);
                }
            }
        }
        return (Optional)($value == this.object ? null : $value);
    }
}

