/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.util;

import com.cumulocity.model.util.DateTimeConverter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;

public class DateTimeUtils {
    public static Chronology chronologyUTC() {
        return ISOChronology.getInstanceUTC();
    }

    public static Chronology chronologyLocal() {
        return ISOChronology.getInstance();
    }

    public static DateTime nowUTC() {
        return new DateTime(org.joda.time.DateTimeUtils.currentTimeMillis(), DateTimeUtils.chronologyUTC());
    }

    @Deprecated
    public static DateTime nowLocal() {
        return DateTimeUtils.convertNameToOffset(new DateTime(org.joda.time.DateTimeUtils.currentTimeMillis(), DateTimeUtils.chronologyLocal()));
    }

    public static DateTime nowDateTimeLocal() {
        return new DateTime(org.joda.time.DateTimeUtils.currentTimeMillis(), DateTimeUtils.chronologyLocal());
    }

    public static DateTime convertNameToOffset(DateTime dateTime) {
        return DateTimeConverter.string2Date(DateTimeConverter.date2String(dateTime));
    }

    public static void checkChronologyUTC(DateTime dateTime) {
        if (dateTime != null && !DateTimeUtils.chronologyUTC().equals(dateTime.getChronology())) {
            throw new IllegalStateException();
        }
    }

    public static DateTime newUTC(long millis) {
        return new DateTime((Object)new Date(millis), DateTimeUtils.chronologyUTC());
    }

    public static DateTime newUTC(Date date) {
        return new DateTime((Object)date, DateTimeUtils.chronologyUTC());
    }

    public static DateTime newLocal(long millis) {
        return DateTimeUtils.convertNameToOffset(new DateTime((Object)new Date(millis), DateTimeUtils.chronologyLocal()));
    }

    public static DateTime newLocal(Date date) {
        return DateTimeUtils.convertNameToOffset(new DateTime((Object)date, DateTimeUtils.chronologyLocal()));
    }

    @Deprecated
    public static DateTime nowLocalMidnight() {
        return DateTimeUtils.toMidnight(DateTimeUtils.nowLocal());
    }

    public static DateTime beginningOfDay(DateTime time) {
        if (time == null) {
            return null;
        }
        return time.withChronology(DateTimeUtils.chronologyLocal()).withTimeAtStartOfDay().withChronology(time.getChronology());
    }

    public static Interval today() {
        DateTime beginningOfDay = DateTimeUtils.beginningOfDay(DateTimeUtils.nowLocal());
        return DateTimeUtils.toChronologyUTC(new Interval((ReadableInstant)beginningOfDay, (ReadableInstant)beginningOfDay.plusDays(1)));
    }

    public static DateTime endOfDay(DateTime time) {
        return DateTimeUtils.toMidnight(time).plusDays(1);
    }

    public static DateTime beginningOfTodayLocal() {
        return DateTimeUtils.beginningOfDay(DateTimeUtils.nowLocal());
    }

    public static DateTime endOfTodayLocal() {
        return DateTimeUtils.endOfDay(DateTimeUtils.nowLocal());
    }

    @Deprecated
    public static DateTime toMidnight(DateTime dateTime) {
        return new DateMidnight((Object)dateTime).toDateTime();
    }

    public static DateTime nowUTCMidnight() {
        return DateTimeUtils.beginningOfTodayLocal().withChronology(DateTimeUtils.chronologyUTC());
    }

    public static DateTime newLocal(Date date, int offsetInMillis) {
        return DateTimeUtils.convertNameToOffset(new DateTime((Object)date, (Chronology)ISOChronology.getInstance((DateTimeZone)DateTimeZone.forOffsetMillis((int)offsetInMillis))));
    }

    public static DateTime toChronologyUTC(DateTime dateTime) {
        return dateTime.withChronology(DateTimeUtils.chronologyUTC());
    }

    public static Interval toChronologyUTC(Interval interval) {
        return interval.withChronology(DateTimeUtils.chronologyUTC());
    }

    public static DateTime toUTC(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toDateTime(DateTimeUtils.chronologyUTC());
    }

    public static DateTime beginningOfMonth(DateTime dateTime) {
        return DateTimeUtils.beginningOfDay(dateTime.withDayOfMonth(1));
    }

    public static DateTime endOfMonth(DateTime dateTime) {
        return DateTimeUtils.beginningOfDay(dateTime.withDayOfMonth(1).plusMonths(1));
    }

    public static List<Interval> splitInterval(Interval interval, Duration chunk) {
        DateTime subEnd;
        DateTime subStart = interval.getStart();
        ArrayList<Interval> list = new ArrayList<Interval>();
        do {
            if ((subEnd = subStart.plus((ReadableDuration)chunk)).isAfter((ReadableInstant)interval.getEnd())) {
                subEnd = interval.getEnd();
            }
            list.add(new Interval((ReadableInstant)subStart, (ReadableInstant)subEnd));
        } while ((subStart = subEnd).isBefore((ReadableInstant)interval.getEnd()));
        return list;
    }

    public static DateTime theBeginningOfEpoch() {
        return new DateTime(0L);
    }
}

