/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.application.microservice.validation;

import com.cumulocity.model.Cpu;
import com.cumulocity.model.application.microservice.validation.MinCpu;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class CpuLimitValidator
implements ConstraintValidator<MinCpu, String> {
    private Cpu minimal;

    public void initialize(MinCpu validCpu) {
        this.minimal = (Cpu)Cpu.tryParse(validCpu.value()).get();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        Optional<Cpu> parsed = Cpu.tryParse(value);
        return Strings.isNullOrEmpty((String)value) || !parsed.isPresent() || ((Cpu)parsed.get()).compareTo(this.minimal) >= 0;
    }
}

