/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.application;

import com.cumulocity.model.ConfigurationOption;
import com.cumulocity.model.Extension;
import com.cumulocity.model.JSONBase;
import com.cumulocity.model.RequestedResources;
import com.cumulocity.model.Resources;
import com.cumulocity.model.application.microservice.validation.Probe;
import com.cumulocity.model.application.microservice.validation.Provider;
import com.cumulocity.model.application.microservice.validation.ValidContextPath;
import com.cumulocity.model.application.microservice.validation.ValidProbe;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.svenson.JSONProperty;
import org.svenson.JSONTypeHint;

public class MicroserviceManifest
extends JSONBase {
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String apiVersion;
    @ValidContextPath
    private String contextPath;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String version;
    @NotNull
    @Valid
    private Provider provider;
    private Isolation isolation;
    private String expose;
    private Scale scale;
    @Min(value=1L)
    @Max(value=5L)
    private @Min(value=1L) @Max(value=5L) Integer replicas;
    private String price;
    @Valid
    @ValidProbe
    private Probe livenessProbe;
    @Valid
    @ValidProbe
    private Probe readinessProbe;
    @Valid
    private RequestedResources requestedResources;
    @Valid
    private Resources resources;
    @Valid
    private List<ConfigurationOption> settings;
    @Pattern(regexp="[a-zA-Z]+")
    private @Pattern(regexp="[a-zA-Z]+") String settingsCategory;
    private List<String> requiredRoles;
    private List<String> roles;
    private List<Extension> extensions;
    private BillingMode billingMode;

    @JSONProperty(ignoreIfNull=true)
    public List<String> getRequiredRoles() {
        return (List)MoreObjects.firstNonNull(this.requiredRoles, Collections.emptyList());
    }

    @JSONProperty(ignoreIfNull=true)
    public List<String> getRoles() {
        return (List)MoreObjects.firstNonNull(this.roles, Collections.emptyList());
    }

    public static MicroserviceManifest from(String manifest) {
        return JSONBase.fromJSON(manifest, MicroserviceManifest.class);
    }

    public static MicroserviceManifest from(BufferedReader reader) {
        return JSONBase.fromJSON(reader, MicroserviceManifest.class);
    }

    public static Function<MicroserviceManifest, String> toVersion() {
        return new Function<MicroserviceManifest, String>(){

            public String apply(MicroserviceManifest manifest) {
                return manifest.getVersion();
            }
        };
    }

    @Generated
    private static BillingMode $default$billingMode() {
        return BillingMode.RESOURCES;
    }

    @Generated
    public static MicroserviceManifestBuilder builder() {
        return new MicroserviceManifestBuilder();
    }

    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Provider getProvider() {
        return this.provider;
    }

    @Generated
    public String getSettingsCategory() {
        return this.settingsCategory;
    }

    @Generated
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Generated
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    @Generated
    public void setIsolation(Isolation isolation) {
        this.isolation = isolation;
    }

    @Generated
    public void setExpose(String expose) {
        this.expose = expose;
    }

    @Generated
    public void setScale(Scale scale) {
        this.scale = scale;
    }

    @Generated
    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    @Generated
    public void setPrice(String price) {
        this.price = price;
    }

    @Generated
    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @Generated
    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @Generated
    public void setRequestedResources(RequestedResources requestedResources) {
        this.requestedResources = requestedResources;
    }

    @Generated
    public void setResources(Resources resources) {
        this.resources = resources;
    }

    @Generated
    public void setSettings(List<ConfigurationOption> settings) {
        this.settings = settings;
    }

    @Generated
    public void setSettingsCategory(String settingsCategory) {
        this.settingsCategory = settingsCategory;
    }

    @Generated
    public void setRequiredRoles(List<String> requiredRoles) {
        this.requiredRoles = requiredRoles;
    }

    @Generated
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    @Generated
    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    @Generated
    public void setBillingMode(BillingMode billingMode) {
        this.billingMode = billingMode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicroserviceManifest)) {
            return false;
        }
        MicroserviceManifest other = (MicroserviceManifest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$contextPath = this.getContextPath();
        String other$contextPath = other.getContextPath();
        if (this$contextPath == null ? other$contextPath != null : !this$contextPath.equals(other$contextPath)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Provider this$provider = this.getProvider();
        Provider other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !((Object)this$provider).equals(other$provider)) {
            return false;
        }
        Isolation this$isolation = this.getIsolation();
        Isolation other$isolation = other.getIsolation();
        if (this$isolation == null ? other$isolation != null : !((Object)((Object)this$isolation)).equals((Object)other$isolation)) {
            return false;
        }
        String this$expose = this.getExpose();
        String other$expose = other.getExpose();
        if (this$expose == null ? other$expose != null : !this$expose.equals(other$expose)) {
            return false;
        }
        Scale this$scale = this.getScale();
        Scale other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)((Object)this$scale)).equals((Object)other$scale)) {
            return false;
        }
        String this$price = this.getPrice();
        String other$price = other.getPrice();
        if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
            return false;
        }
        Probe this$livenessProbe = this.getLivenessProbe();
        Probe other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        Probe this$readinessProbe = this.getReadinessProbe();
        Probe other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        RequestedResources this$requestedResources = this.getRequestedResources();
        RequestedResources other$requestedResources = other.getRequestedResources();
        if (this$requestedResources == null ? other$requestedResources != null : !((Object)this$requestedResources).equals(other$requestedResources)) {
            return false;
        }
        Resources this$resources = this.getResources();
        Resources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        List<ConfigurationOption> this$settings = this.getSettings();
        List<ConfigurationOption> other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        String this$settingsCategory = this.getSettingsCategory();
        String other$settingsCategory = other.getSettingsCategory();
        if (this$settingsCategory == null ? other$settingsCategory != null : !this$settingsCategory.equals(other$settingsCategory)) {
            return false;
        }
        List<String> this$requiredRoles = this.getRequiredRoles();
        List<String> other$requiredRoles = other.getRequiredRoles();
        if (this$requiredRoles == null ? other$requiredRoles != null : !((Object)this$requiredRoles).equals(other$requiredRoles)) {
            return false;
        }
        List<String> this$roles = this.getRoles();
        List<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        List<Extension> this$extensions = this.getExtensions();
        List<Extension> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        BillingMode this$billingMode = this.getBillingMode();
        BillingMode other$billingMode = other.getBillingMode();
        return !(this$billingMode == null ? other$billingMode != null : !((Object)((Object)this$billingMode)).equals((Object)other$billingMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MicroserviceManifest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $contextPath = this.getContextPath();
        result = result * 59 + ($contextPath == null ? 43 : $contextPath.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Provider $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : ((Object)$provider).hashCode());
        Isolation $isolation = this.getIsolation();
        result = result * 59 + ($isolation == null ? 43 : ((Object)((Object)$isolation)).hashCode());
        String $expose = this.getExpose();
        result = result * 59 + ($expose == null ? 43 : $expose.hashCode());
        Scale $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)((Object)$scale)).hashCode());
        String $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        Probe $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        Probe $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        RequestedResources $requestedResources = this.getRequestedResources();
        result = result * 59 + ($requestedResources == null ? 43 : ((Object)$requestedResources).hashCode());
        Resources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        List<ConfigurationOption> $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        String $settingsCategory = this.getSettingsCategory();
        result = result * 59 + ($settingsCategory == null ? 43 : $settingsCategory.hashCode());
        List<String> $requiredRoles = this.getRequiredRoles();
        result = result * 59 + ($requiredRoles == null ? 43 : ((Object)$requiredRoles).hashCode());
        List<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        List<Extension> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        BillingMode $billingMode = this.getBillingMode();
        result = result * 59 + ($billingMode == null ? 43 : ((Object)((Object)$billingMode)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MicroserviceManifest(apiVersion=" + this.getApiVersion() + ", contextPath=" + this.getContextPath() + ", version=" + this.getVersion() + ", provider=" + this.getProvider() + ", isolation=" + this.getIsolation() + ", expose=" + this.getExpose() + ", scale=" + this.getScale() + ", replicas=" + this.getReplicas() + ", price=" + this.getPrice() + ", livenessProbe=" + this.getLivenessProbe() + ", readinessProbe=" + this.getReadinessProbe() + ", requestedResources=" + this.getRequestedResources() + ", resources=" + this.getResources() + ", settings=" + this.getSettings() + ", settingsCategory=" + this.getSettingsCategory() + ", requiredRoles=" + this.getRequiredRoles() + ", roles=" + this.getRoles() + ", extensions=" + this.getExtensions() + ", billingMode=" + this.getBillingMode() + ")";
    }

    @Generated
    public MicroserviceManifest() {
        this.billingMode = MicroserviceManifest.$default$billingMode();
    }

    @Generated
    private MicroserviceManifest(String apiVersion, String contextPath, String version, Provider provider, Isolation isolation, String expose, Scale scale, Integer replicas, String price, Probe livenessProbe, Probe readinessProbe, RequestedResources requestedResources, Resources resources, List<ConfigurationOption> settings, String settingsCategory, List<String> requiredRoles, List<String> roles, List<Extension> extensions, BillingMode billingMode) {
        this.apiVersion = apiVersion;
        this.contextPath = contextPath;
        this.version = version;
        this.provider = provider;
        this.isolation = isolation;
        this.expose = expose;
        this.scale = scale;
        this.replicas = replicas;
        this.price = price;
        this.livenessProbe = livenessProbe;
        this.readinessProbe = readinessProbe;
        this.requestedResources = requestedResources;
        this.resources = resources;
        this.settings = settings;
        this.settingsCategory = settingsCategory;
        this.requiredRoles = requiredRoles;
        this.roles = roles;
        this.extensions = extensions;
        this.billingMode = billingMode;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public String getContextPath() {
        return this.contextPath;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public Isolation getIsolation() {
        return this.isolation;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public String getExpose() {
        return this.expose;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public Scale getScale() {
        return this.scale;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public Integer getReplicas() {
        return this.replicas;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public String getPrice() {
        return this.price;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public RequestedResources getRequestedResources() {
        return this.requestedResources;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public Resources getResources() {
        return this.resources;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=ConfigurationOption.class)
    @Generated
    public List<ConfigurationOption> getSettings() {
        return this.settings;
    }

    @JSONProperty(ignoreIfNull=true)
    @JSONTypeHint(value=Extension.class)
    @Generated
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    @JSONProperty(ignoreIfNull=true)
    @Generated
    public BillingMode getBillingMode() {
        return this.billingMode;
    }

    public static enum BillingMode {
        SUBSCRIPTION,
        RESOURCES;

    }

    @Generated
    public static class MicroserviceManifestBuilder {
        @Generated
        private String apiVersion;
        @Generated
        private String contextPath;
        @Generated
        private String version;
        @Generated
        private Provider provider;
        @Generated
        private Isolation isolation;
        @Generated
        private String expose;
        @Generated
        private Scale scale;
        @Generated
        private Integer replicas;
        @Generated
        private String price;
        @Generated
        private Probe livenessProbe;
        @Generated
        private Probe readinessProbe;
        @Generated
        private RequestedResources requestedResources;
        @Generated
        private Resources resources;
        @Generated
        private ArrayList<ConfigurationOption> settings;
        @Generated
        private String settingsCategory;
        @Generated
        private List<String> requiredRoles;
        @Generated
        private List<String> roles;
        @Generated
        private ArrayList<Extension> extensions;
        @Generated
        private boolean billingMode$set;
        @Generated
        private BillingMode billingMode$value;

        @Generated
        MicroserviceManifestBuilder() {
        }

        @Generated
        public MicroserviceManifestBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder provider(Provider provider) {
            this.provider = provider;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder isolation(Isolation isolation) {
            this.isolation = isolation;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder expose(String expose) {
            this.expose = expose;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder scale(Scale scale) {
            this.scale = scale;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder replicas(Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder price(String price) {
            this.price = price;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder livenessProbe(Probe livenessProbe) {
            this.livenessProbe = livenessProbe;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder readinessProbe(Probe readinessProbe) {
            this.readinessProbe = readinessProbe;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder requestedResources(RequestedResources requestedResources) {
            this.requestedResources = requestedResources;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder resources(Resources resources) {
            this.resources = resources;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder setting(ConfigurationOption setting) {
            if (this.settings == null) {
                this.settings = new ArrayList();
            }
            this.settings.add(setting);
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder settings(Collection<? extends ConfigurationOption> settings) {
            if (settings == null) {
                throw new NullPointerException("settings cannot be null");
            }
            if (this.settings == null) {
                this.settings = new ArrayList();
            }
            this.settings.addAll(settings);
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder clearSettings() {
            if (this.settings != null) {
                this.settings.clear();
            }
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder settingsCategory(String settingsCategory) {
            this.settingsCategory = settingsCategory;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder requiredRoles(List<String> requiredRoles) {
            this.requiredRoles = requiredRoles;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder extension(Extension extension) {
            if (this.extensions == null) {
                this.extensions = new ArrayList();
            }
            this.extensions.add(extension);
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder extensions(Collection<? extends Extension> extensions) {
            if (extensions == null) {
                throw new NullPointerException("extensions cannot be null");
            }
            if (this.extensions == null) {
                this.extensions = new ArrayList();
            }
            this.extensions.addAll(extensions);
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder clearExtensions() {
            if (this.extensions != null) {
                this.extensions.clear();
            }
            return this;
        }

        @Generated
        public MicroserviceManifestBuilder billingMode(BillingMode billingMode) {
            this.billingMode$value = billingMode;
            this.billingMode$set = true;
            return this;
        }

        @Generated
        public MicroserviceManifest build() {
            List<ConfigurationOption> settings = switch (this.settings == null ? 0 : this.settings.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.settings.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ConfigurationOption>(this.settings));
            };
            List<Extension> extensions = switch (this.extensions == null ? 0 : this.extensions.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.extensions.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Extension>(this.extensions));
            };
            BillingMode billingMode$value = this.billingMode$value;
            if (!this.billingMode$set) {
                billingMode$value = MicroserviceManifest.$default$billingMode();
            }
            return new MicroserviceManifest(this.apiVersion, this.contextPath, this.version, this.provider, this.isolation, this.expose, this.scale, this.replicas, this.price, this.livenessProbe, this.readinessProbe, this.requestedResources, this.resources, settings, this.settingsCategory, this.requiredRoles, this.roles, extensions, billingMode$value);
        }

        @Generated
        public String toString() {
            return "MicroserviceManifest.MicroserviceManifestBuilder(apiVersion=" + this.apiVersion + ", contextPath=" + this.contextPath + ", version=" + this.version + ", provider=" + this.provider + ", isolation=" + this.isolation + ", expose=" + this.expose + ", scale=" + this.scale + ", replicas=" + this.replicas + ", price=" + this.price + ", livenessProbe=" + this.livenessProbe + ", readinessProbe=" + this.readinessProbe + ", requestedResources=" + this.requestedResources + ", resources=" + this.resources + ", settings=" + this.settings + ", settingsCategory=" + this.settingsCategory + ", requiredRoles=" + this.requiredRoles + ", roles=" + this.roles + ", extensions=" + this.extensions + ", billingMode$value=" + this.billingMode$value + ")";
        }
    }

    public static enum Isolation {
        PER_TENANT,
        MULTI_TENANT;

    }

    public static enum Scale {
        NONE,
        AUTO;

    }
}

