/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.uploadMojo.configuration.common;

import com.cumulocity.agent.packaging.uploadMojo.configuration.common.XmlNodeUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.settings.Server;

public final class ServerUtils {
    public static Function<Server, String> getConfigurationString(final String ... path) {
        return new Function<Server, String>(){

            public String apply(Server input) {
                return (String)XmlNodeUtils.getPropertyNode(input.getConfiguration(), path).transform(XmlNodeUtils.getStringValue()).orNull();
            }
        };
    }

    public static <T> Function<Server, List<T>> getConfigurationList(final Class<T> target, final String ... path) {
        return new Function<Server, List<T>>(){

            public List<T> apply(Server input) {
                return (List)XmlNodeUtils.getPropertyNode(input.getConfiguration(), path).transform(XmlNodeUtils.getListValue(target)).or((Object)Lists.newArrayList());
            }
        };
    }

    public static Function<Server, String> getServerPassword() {
        return new Function<Server, String>(){

            public String apply(Server input) {
                return input.getPassword();
            }
        };
    }

    public static Function<Server, String> getServerUsername() {
        return new Function<Server, String>(){

            public String apply(Server input) {
                return input.getUsername();
            }
        };
    }

    public static Predicate<String> isNotBlank() {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return StringUtils.isNotBlank((CharSequence)input);
            }
        };
    }

    @Generated
    private ServerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

