/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging;

import com.cumulocity.agent.packaging.BaseMicroserviceMojo;
import com.cumulocity.agent.packaging.DockerImage;
import com.cumulocity.agent.packaging.microservice.MicroserviceDockerClient;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="push", defaultPhase=LifecyclePhase.DEPLOY, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class DeployMojo
extends BaseMicroserviceMojo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployMojo.class);
    @Component
    private MicroserviceDockerClient dockerClient;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.containerSkip) {
            this.getLog().info((CharSequence)"skipping agent deploy");
            return;
        }
        if (Strings.isNullOrEmpty((String)this.registry)) {
            this.getLog().warn((CharSequence)"docker registry is undefined skipping push");
            return;
        }
        ImmutableList tags = ImmutableList.of((Object)"latest", (Object)this.project.getVersion());
        for (String tag : tags) {
            this.publish(tag);
        }
        DockerImage image = DockerImage.ofName(this.name);
        this.cleanup(image);
        this.cleanup(image.withRegistry(this.registry));
    }

    private void publish(String tag) throws MojoExecutionException {
        log.info("Publishing image to registry");
        DockerImage source = DockerImage.ofName(this.name).withTag(tag);
        DockerImage pushed = source.withRegistry(this.registry);
        this.dockerClient.tagImage(source.toString(), pushed.toString(), tag);
        this.dockerClient.pushImage(pushed.toString());
    }

    public void cleanup(DockerImage image) throws MojoExecutionException {
        log.info("Running cleanup on {} with tags", (Object)image.toString());
        this.dockerClient.deleteAll(image.toString(), true);
    }
}

