/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.util;

import lombok.Generated;

public enum CumulocityStorageUnit {
    Bi(1L),
    Ki(1024L),
    Mi(0x100000L),
    Gi(0x40000000L),
    Ti(0x10000000000L),
    Pi(0x4000000000000L),
    Ei(0x1000000000000000L),
    B(1L),
    K(CumulocityStorageUnit.pow10(3)),
    M(CumulocityStorageUnit.pow10(6)),
    G(CumulocityStorageUnit.pow10(9)),
    T(CumulocityStorageUnit.pow10(12)),
    P(CumulocityStorageUnit.pow10(15)),
    E(CumulocityStorageUnit.pow10(18));

    private long byteLen;

    private CumulocityStorageUnit(long value) {
        this.byteLen = value;
    }

    public static long getBytes(long quantity, String unit) {
        CumulocityStorageUnit storageUnit = CumulocityStorageUnit.valueOf(unit);
        return quantity * storageUnit.byteLen;
    }

    private static long pow10(int exponent) {
        return (long)Math.pow(10.0, exponent);
    }

    @Generated
    public long getByteLen() {
        return this.byteLen;
    }
}

