/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model.application.microservice.validation;

import com.cumulocity.model.DataSize;
import com.cumulocity.model.application.microservice.validation.MinDataSize;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Range;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class MinDataSizeValidator
implements ConstraintValidator<MinDataSize, String> {
    private DataSize minimum;
    private Optional<DataSize> maximum;

    public void initialize(MinDataSize valid) {
        this.minimum = DataSize.parse(valid.value());
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        Optional<DataSize> parsed = DataSize.tryParse(value);
        return Strings.isNullOrEmpty((String)value) || !parsed.isPresent() || this.inRange(parsed);
    }

    private boolean inRange(Optional<DataSize> parsed) {
        return Range.atLeast((Comparable)this.minimum).contains((Comparable)((DataSize)parsed.get()));
    }
}

