/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Doubles;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class Cpu
implements Comparable<Cpu> {
    public static final String CPU_ZERO_MILLIS = "0m";
    public static final String CPU_VALUE_PATTERN = "\\d+(\\.\\d+)?m?";
    private static final Pattern CPU_PATTERN = Pattern.compile("\\d+(\\.\\d+)?m?");
    private final BigDecimal value;

    private Cpu(BigDecimal value) {
        this.value = (BigDecimal)Preconditions.checkNotNull((Object)value, (Object)"value can't be null");
    }

    public BigDecimal asMillis() {
        return this.value;
    }

    @Override
    public int compareTo(Cpu o) {
        return this.value.compareTo(o.value);
    }

    public String toString() {
        return this.value.longValue() + "m";
    }

    public static Optional<Cpu> tryParse(String value) {
        if (Strings.isNullOrEmpty((String)value) || !CPU_PATTERN.matcher(value).matches()) {
            return Optional.absent();
        }
        return Optional.of((Object)Cpu.parse(value));
    }

    public static Cpu parse(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Cpu string can't be null");
        Matcher matcher = CPU_PATTERN.matcher(value);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)("Cpu needs to match " + CPU_PATTERN.pattern()));
        BigDecimal millis = Cpu.parseMillis(value);
        return new Cpu(millis);
    }

    public static Cpu valueOf(BigDecimal value) {
        return new Cpu(value);
    }

    private static BigDecimal parseMillis(String value) {
        if (value.endsWith("m")) {
            return BigDecimal.valueOf(Double.valueOf(Cpu.removeLastChar(value))).setScale(0);
        }
        return BigDecimal.valueOf(Doubles.tryParse((String)value)).multiply(BigDecimal.valueOf(1000L)).setScale(0);
    }

    private static String removeLastChar(String string) {
        return string.substring(0, string.length() - 1);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cpu)) {
            return false;
        }
        Cpu other = (Cpu)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$value = this.value;
        BigDecimal other$value = other.value;
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cpu;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

