/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.uploadMojo.configuration.common;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public final class XmlNodeUtils {
    public static Function<Xpp3Dom, String> getStringValue() {
        return new Function<Xpp3Dom, String>(){

            public String apply(Xpp3Dom input) {
                return input.getValue();
            }
        };
    }

    public static <T> Function<Xpp3Dom, List<T>> getListValue(final Class<T> target) {
        return new Function<Xpp3Dom, List<T>>(){

            public List<T> apply(Xpp3Dom input) {
                return XmlNodeUtils.getListValue(input, target);
            }
        };
    }

    public static Optional<Xpp3Dom> getPropertyNode(Object root, String ... path) {
        if (root instanceof Xpp3Dom) {
            Xpp3Dom node = (Xpp3Dom)root;
            for (String element : path) {
                if ((node = node.getChild(element)) != null) continue;
                return Optional.absent();
            }
            return Optional.of((Object)node);
        }
        return Optional.absent();
    }

    private static <T> List<T> getListValue(Xpp3Dom input, Class<T> target) {
        if (input == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Xpp3Dom child : input.getChildren()) {
            result.add(XmlNodeUtils.getObjectValue(child, target));
        }
        return result;
    }

    private static <T> T getObjectValue(Xpp3Dom child, Class<T> target) {
        if (String.class.equals(target)) {
            return (T)child.getValue();
        }
        T element = target.newInstance();
        for (Field field : target.getDeclaredFields()) {
            Type genericType;
            field.setAccessible(true);
            Xpp3Dom propertyNode = child.getChild(field.getName());
            if (propertyNode == null) continue;
            Class<?> fieldType = field.getType();
            if (String.class.equals(fieldType)) {
                field.set(element, propertyNode.getValue());
            }
            if (Boolean.class.equals(fieldType)) {
                field.set(element, Boolean.valueOf(propertyNode.getValue()));
            }
            if (!List.class.equals(fieldType) || !((genericType = field.getGenericType()) instanceof ParameterizedType)) continue;
            ParameterizedType pType = (ParameterizedType)genericType;
            Type type = pType.getActualTypeArguments()[0];
            field.set(element, XmlNodeUtils.getListValue(propertyNode, (Class)type));
        }
        return element;
    }

    @Generated
    private XmlNodeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

