/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.microservice.impl;

import com.cumulocity.agent.packaging.microservice.MicroserviceDockerClient;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.SaveImageCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.okhttp.OkDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.maven.MavenExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StartingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=MicroserviceDockerClient.class)
public class MicroserviceDockerClientImpl
extends AbstractLogEnabled
implements MicroserviceDockerClient,
Startable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"MicroserviceDockerClient");
    DockerClient dockerClient;
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    public synchronized void buildDockerImage(String dockerDirectory, Set<String> tags, Map<String, String> buildArgs, String platform, String networkMode, Integer dockerBuildTimeout, AuthConfigurations pullConfiguration) {
        BuildImageCmd buildImageCmd = this.dockerClient.buildImageCmd(new File(dockerDirectory)).withTags(tags).withPlatform(platform).withBuildAuthConfigs(pullConfiguration);
        for (Map.Entry<String, String> buildArgument : buildArgs.entrySet()) {
            buildImageCmd = buildImageCmd.withBuildArg(buildArgument.getKey(), buildArgument.getValue());
        }
        if (!Strings.isNullOrEmpty((String)networkMode)) {
            buildImageCmd = buildImageCmd.withNetworkMode(networkMode);
        }
        log.info("Building Docker image. Docker dir={},tags={}, build arguments={}, platform={}", new Object[]{dockerDirectory, tags, buildArgs, platform});
        ImageBuildCompletionWaiter imageBuildCompletionWaiter = new ImageBuildCompletionWaiter();
        buildImageCmd.exec((ResultCallback)imageBuildCompletionWaiter);
        log.info("Waiting for image build to complete (timeout={}s)", (Object)dockerBuildTimeout);
        imageBuildCompletionWaiter.awaitWithTimeout(dockerBuildTimeout);
        log.info("Image build success");
    }

    @Override
    public synchronized void saveDockerImage(String image, OutputStream outputStream) throws MavenExecutionException {
        log.info("Saving image {} to output stream", (Object)image);
        try {
            SaveImageCmd saveImageCmd = this.dockerClient.saveImageCmd(image);
            InputStream inputStream = saveImageCmd.exec();
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            log.error("Save image failed, reason was: {}", (Object)e.getMessage());
            throw new MavenExecutionException("Docker save failed", (Throwable)e);
        }
    }

    private static DockerClient newDockerClient() {
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
        log.debug("Docker Configuration used: {}", (Object)config);
        OkDockerHttpClient httpClient = new OkDockerHttpClient.Builder().dockerHost(config.getDockerHost()).build();
        return DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
    }

    @Override
    public synchronized void deleteAll(String imageName, boolean withForce) {
        log.info("Cleaning up all docker images for {} ", (Object)imageName);
        ListImagesCmd listImagesCmd = this.dockerClient.listImagesCmd();
        listImagesCmd.getFilters().putAll(this.getImageNameFilter(imageName));
        List images = (List)listImagesCmd.exec();
        log.info("Found the following images for deletion {}", (Object)images);
        for (Image image : images) {
            log.info("Removing {} {}", (Object)image.getId(), (Object)image.getRepoTags());
            try {
                RemoveImageCmd removeImageCmd = this.dockerClient.removeImageCmd(image.getId()).withForce(Boolean.valueOf(withForce));
                removeImageCmd.exec();
                log.info(" -> Successfully removed image {} ", (Object)removeImageCmd.getImageId());
            }
            catch (Exception e) {
                log.error("Failed to remove image {}, reason: ", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void tagImage(String image, String imageNameWithRepository, String tag) {
        log.info("Tagging image {} image / {} with tag {}", new Object[]{image, imageNameWithRepository, tag});
        TagImageCmd tagImageCmd = this.dockerClient.tagImageCmd(image, imageNameWithRepository, tag);
        tagImageCmd.exec();
    }

    @Override
    public synchronized void pushImage(String name) {
        log.info("Pushing docker image to registry");
        PushImageCmd pushImageCmd = this.dockerClient.pushImageCmd(name);
        PushImageResponseCallBack callBack = new PushImageResponseCallBack();
        pushImageCmd.exec((ResultCallback)callBack);
        callBack.waitForCompletionOrFailure();
    }

    @Override
    public void waitForImageInRegistry(String image, int timeOutSeconds) {
        log.info("Waiting for image {} to appear in registry, timeout={}s", (Object)image, (Object)timeOutSeconds);
        Map<String, List<String>> nameFilter = this.getImageNameFilter(image);
        ListImagesCmd listImagesCmd = this.dockerClient.listImagesCmd();
        listImagesCmd.getFilters().putAll(nameFilter);
        List imagesFound = (List)listImagesCmd.exec();
        long timeOutTimeStamp = System.currentTimeMillis() + 1000L * (long)timeOutSeconds;
        while (imagesFound.isEmpty()) {
            if (System.currentTimeMillis() > timeOutTimeStamp) {
                throw new RuntimeException("Waiting for image timed out after " + timeOutSeconds + "seconds");
            }
            Thread.sleep(2000L);
            log.info("Image {} not found in registry, retrying...", (Object)image);
            imagesFound = (List)listImagesCmd.exec();
        }
        log.info("Image appeared in registry.");
    }

    private Map<String, List<String>> getImageNameFilter(String imageName) {
        HashMap imageFilters = Maps.newHashMap();
        imageFilters.put("reference", Lists.newArrayList((Object[])new String[]{imageName}));
        return imageFilters;
    }

    public void start() throws StartingException {
        this.getLogger().debug("Starting docker client ");
        if (this.dockerClient == null) {
            try {
                this.dockerClient = MicroserviceDockerClientImpl.newDockerClient();
            }
            catch (Exception e) {
                throw new StartingException("Can't initialize docker client" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stop() {
        this.getLogger().debug("Stopping docker client ");
        if (Objects.nonNull(this.dockerClient)) {
            try {
                this.dockerClient.close();
            }
            catch (IOException e) {
                log.error("Can't close docker client. Reason: {}", (Throwable)e);
            }
        }
    }

    protected static class ImageBuildCompletionWaiter
    extends BuildImageResultCallback {
        String completedImageId;
        boolean buildFailed;
        private Future f;

        protected ImageBuildCompletionWaiter() {
        }

        public void awaitWithTimeout(int seconds) throws MavenExecutionException {
            try {
                this.f = executorService.submit(() -> {
                    while (Objects.isNull(this.completedImageId)) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {
                            log.error("Waiting for Docker completion was interrupted");
                        }
                    }
                    log.info("Build successful, imageId: {}", (Object)this.completedImageId);
                });
                this.f.get(seconds, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                throw new MavenExecutionException("Docker build timed out", (Throwable)timeoutException);
            }
            catch (ExecutionException e) {
                throw new MavenExecutionException("Docker build execution failed", (Throwable)e);
            }
            catch (CancellationException c) {
                throw new MavenExecutionException("Docker image build failed. See logs above", (Throwable)c);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MavenExecutionException("Docker build execution was interrupted", (Throwable)e);
            }
        }

        public void onNext(BuildResponseItem item) {
            if (Objects.nonNull(item.getStream())) {
                log.info(item.getStream());
            }
            if (item.isBuildSuccessIndicated()) {
                this.completedImageId = item.getImageId();
            } else if (item.isErrorIndicated()) {
                this.buildFailed = true;
                String errorMessage = String.format("Docker build error: %s %s", item.getErrorDetail().getCode(), item.getErrorDetail().getMessage());
                log.error(errorMessage);
                this.f.cancel(true);
            }
        }
    }

    private static class PushImageResponseCallBack
    implements ResultCallback<PushResponseItem> {
        AtomicBoolean pushProcessDone = new AtomicBoolean(false);

        private PushImageResponseCallBack() {
        }

        private void waitForCompletionOrFailure() {
            while (!this.pushProcessDone.get()) {
                Thread.sleep(250L);
            }
        }

        public void onStart(Closeable closeable) {
            log.info("Started pushing image to registry");
        }

        public void onNext(PushResponseItem object) {
            if (object.isErrorIndicated()) {
                ResponseItem.ErrorDetail errorDetail = object.getErrorDetail();
                if (Objects.nonNull(errorDetail.getMessage())) {
                    throw new RuntimeException(errorDetail.getMessage());
                }
                throw new RuntimeException(errorDetail.toString());
            }
            if (Objects.nonNull(object.getStream())) {
                log.info(object.getStream());
            }
        }

        public void onError(Throwable throwable) {
            this.pushProcessDone.set(true);
            log.error("Could not push image");
            throw throwable;
        }

        public void onComplete() {
            this.pushProcessDone.set(true);
            log.info("Successfully pushed image to registry");
        }

        public void close() {
            log.info("Push closed");
        }
    }
}

