/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;

public class DockerBuildInfo {
    private String imageArch;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    private Date buildDate;
    private String builderInfo;
    private String hostPlatform;
    private String hostOS;
    private String hostOSVersion;

    public static DockerBuildInfo defaultInfo() {
        return new DockerBuildInfo();
    }

    public static DockerBuildInfo withBuildArchitecture(String buildArchitecture) {
        DockerBuildInfo result = new DockerBuildInfo();
        result.setImageArch(buildArchitecture);
        return result;
    }

    public DockerBuildInfo withCurrentBuildDate() {
        this.setBuildDate(new Date());
        return this;
    }

    public DockerBuildInfo withHostArchitecture() {
        this.setHostPlatform(SystemUtils.OS_ARCH);
        return this;
    }

    public DockerBuildInfo withHostOS() {
        this.setHostOS(SystemUtils.OS_NAME);
        this.setHostOSVersion(SystemUtils.OS_VERSION);
        return this;
    }

    public DockerBuildInfo withImageArch(String targetArchitecture) {
        this.imageArch = targetArchitecture;
        return this;
    }

    public DockerBuildInfo withBuilderInfo(String builderInfo) {
        this.setBuilderInfo(builderInfo);
        return this;
    }

    @Generated
    public String getImageArch() {
        return this.imageArch;
    }

    @Generated
    public Date getBuildDate() {
        return this.buildDate;
    }

    @Generated
    public String getBuilderInfo() {
        return this.builderInfo;
    }

    @Generated
    public String getHostPlatform() {
        return this.hostPlatform;
    }

    @Generated
    public String getHostOS() {
        return this.hostOS;
    }

    @Generated
    public String getHostOSVersion() {
        return this.hostOSVersion;
    }

    @Generated
    public void setImageArch(String imageArch) {
        this.imageArch = imageArch;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    @Generated
    public void setBuildDate(Date buildDate) {
        this.buildDate = buildDate;
    }

    @Generated
    public void setBuilderInfo(String builderInfo) {
        this.builderInfo = builderInfo;
    }

    @Generated
    public void setHostPlatform(String hostPlatform) {
        this.hostPlatform = hostPlatform;
    }

    @Generated
    public void setHostOS(String hostOS) {
        this.hostOS = hostOS;
    }

    @Generated
    public void setHostOSVersion(String hostOSVersion) {
        this.hostOSVersion = hostOSVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerBuildInfo)) {
            return false;
        }
        DockerBuildInfo other = (DockerBuildInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$imageArch = this.getImageArch();
        String other$imageArch = other.getImageArch();
        if (this$imageArch == null ? other$imageArch != null : !this$imageArch.equals(other$imageArch)) {
            return false;
        }
        Date this$buildDate = this.getBuildDate();
        Date other$buildDate = other.getBuildDate();
        if (this$buildDate == null ? other$buildDate != null : !((Object)this$buildDate).equals(other$buildDate)) {
            return false;
        }
        String this$builderInfo = this.getBuilderInfo();
        String other$builderInfo = other.getBuilderInfo();
        if (this$builderInfo == null ? other$builderInfo != null : !this$builderInfo.equals(other$builderInfo)) {
            return false;
        }
        String this$hostPlatform = this.getHostPlatform();
        String other$hostPlatform = other.getHostPlatform();
        if (this$hostPlatform == null ? other$hostPlatform != null : !this$hostPlatform.equals(other$hostPlatform)) {
            return false;
        }
        String this$hostOS = this.getHostOS();
        String other$hostOS = other.getHostOS();
        if (this$hostOS == null ? other$hostOS != null : !this$hostOS.equals(other$hostOS)) {
            return false;
        }
        String this$hostOSVersion = this.getHostOSVersion();
        String other$hostOSVersion = other.getHostOSVersion();
        return !(this$hostOSVersion == null ? other$hostOSVersion != null : !this$hostOSVersion.equals(other$hostOSVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DockerBuildInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $imageArch = this.getImageArch();
        result = result * 59 + ($imageArch == null ? 43 : $imageArch.hashCode());
        Date $buildDate = this.getBuildDate();
        result = result * 59 + ($buildDate == null ? 43 : ((Object)$buildDate).hashCode());
        String $builderInfo = this.getBuilderInfo();
        result = result * 59 + ($builderInfo == null ? 43 : $builderInfo.hashCode());
        String $hostPlatform = this.getHostPlatform();
        result = result * 59 + ($hostPlatform == null ? 43 : $hostPlatform.hashCode());
        String $hostOS = this.getHostOS();
        result = result * 59 + ($hostOS == null ? 43 : $hostOS.hashCode());
        String $hostOSVersion = this.getHostOSVersion();
        result = result * 59 + ($hostOSVersion == null ? 43 : $hostOSVersion.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DockerBuildInfo(imageArch=" + this.getImageArch() + ", buildDate=" + this.getBuildDate() + ", builderInfo=" + this.getBuilderInfo() + ", hostPlatform=" + this.getHostPlatform() + ", hostOS=" + this.getHostOS() + ", hostOSVersion=" + this.getHostOSVersion() + ")";
    }

    @Generated
    public DockerBuildInfo() {
    }
}

