/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.agent.packaging.uploadMojo.platform.client.impl;

import com.google.common.base.Strings;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;

public class ProgressInputStream
extends FilterInputStream {
    public static final UpdateProgressListener NO_OP_PROGRESS = new UpdateProgressListener(){

        @Override
        public void onStart() {
        }

        @Override
        public void onProgress(int prevValue, int newValue) {
        }

        @Override
        public void onEnd() {
        }
    };
    private final UpdateProgressListener progressListener;
    private final long maxNumBytes;
    private AtomicLong totalNumBytesRead = new AtomicLong(0L);
    private AtomicInteger percents = new AtomicInteger(0);
    private volatile long marked;

    public ProgressInputStream(InputStream inputStream, long maxNumBytes, UpdateProgressListener progressListener) {
        super(inputStream);
        if (progressListener == null) {
            progressListener = NO_OP_PROGRESS;
        }
        this.progressListener = progressListener;
        this.maxNumBytes = maxNumBytes;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        this.updateProgress(1L);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return (int)this.updateProgress(super.read(b, off, len));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.updateProgress(super.skip(n));
    }

    @Override
    public void mark(int readLimit) {
        super.mark(readLimit);
        this.marked = this.totalNumBytesRead.get();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        long prev = this.totalNumBytesRead.get();
        this.totalNumBytesRead.set(this.marked);
        this.updateProgress(this.totalNumBytesRead.get() - prev);
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    private long updateProgress(long numBytesRead) {
        try {
            long newBytes;
            int newPercents;
            int prevPercents;
            if (numBytesRead != 0L && (prevPercents = this.percents.get()) != (newPercents = (int)((newBytes = this.totalNumBytesRead.addAndGet(numBytesRead)) * 100L / this.maxNumBytes))) {
                this.percents.set(newPercents);
                if (prevPercents == 0) {
                    this.progressListener.onStart();
                }
                this.progressListener.onProgress(prevPercents, newPercents);
                if (newPercents == 100) {
                    this.progressListener.onEnd();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return numBytesRead;
    }

    @Generated
    public static ProgressInputStreamBuilder builder() {
        return new ProgressInputStreamBuilder();
    }

    @Generated
    public UpdateProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Generated
    public long getMaxNumBytes() {
        return this.maxNumBytes;
    }

    @Generated
    public AtomicLong getTotalNumBytesRead() {
        return this.totalNumBytesRead;
    }

    @Generated
    public AtomicInteger getPercents() {
        return this.percents;
    }

    @Generated
    public long getMarked() {
        return this.marked;
    }

    public static interface UpdateProgressListener {
        public void onStart();

        public void onProgress(int var1, int var2);

        public void onEnd();
    }

    @Generated
    public static class ProgressInputStreamBuilder {
        @Generated
        private InputStream inputStream;
        @Generated
        private long maxNumBytes;
        @Generated
        private UpdateProgressListener progressListener;

        @Generated
        ProgressInputStreamBuilder() {
        }

        @Generated
        public ProgressInputStreamBuilder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        @Generated
        public ProgressInputStreamBuilder maxNumBytes(long maxNumBytes) {
            this.maxNumBytes = maxNumBytes;
            return this;
        }

        @Generated
        public ProgressInputStreamBuilder progressListener(UpdateProgressListener progressListener) {
            this.progressListener = progressListener;
            return this;
        }

        @Generated
        public ProgressInputStream build() {
            return new ProgressInputStream(this.inputStream, this.maxNumBytes, this.progressListener);
        }

        @Generated
        public String toString() {
            return "ProgressInputStream.ProgressInputStreamBuilder(inputStream=" + this.inputStream + ", maxNumBytes=" + this.maxNumBytes + ", progressListener=" + this.progressListener + ")";
        }
    }

    public static class SysOutProgress
    implements UpdateProgressListener {
        private AtomicInteger progress = new AtomicInteger();

        @Override
        public void onStart() {
            System.out.println("|" + Strings.repeat((String)"-", (int)100) + "|");
            System.out.flush();
            System.out.print("|");
            System.out.flush();
        }

        @Override
        public void onProgress(int prevValue, int newValue) {
            if (newValue > this.progress.get()) {
                int count = newValue - this.progress.get();
                this.progress.set(newValue);
                System.out.print(Strings.repeat((String)"*", (int)count));
                System.out.flush();
            }
        }

        @Override
        public void onEnd() {
            System.out.println("|");
            System.out.flush();
        }
    }
}

